% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.rpart}
\alias{tidy.rpart}
\title{Get the \link{rulelist} from a \link[rpart:rpart]{rpart} model}
\usage{
\method{tidy}{rpart}(x, ...)
}
\arguments{
\item{x}{\link[rpart:rpart]{rpart::rpart} model}

\item{...}{Other arguments (currently unused)}
}
\value{
A \link{rulelist} object
}
\description{
Each row corresponds to a rule
}
\details{
For rpart rules, one should build the model without \link[base:factor]{ordered factor} variable. We recommend you to convert \link[base:factor]{ordered factor} to \link[base:factor]{factor} or \emph{integer} class.

For \link[rpart:rpart]{rpart::rpart} classification model:
\itemize{
\item Output columns are: \code{rule_nbr}, \code{LHS}, \code{RHS}, \code{support}, \code{confidence}, \code{lift}.
\item The rules are sorted in this order: \code{desc(confidence)}, \code{desc(lift)},
\code{desc(support)}.
}

For \link[rpart:rpart]{rpart::rpart} regression(anova) model:
\itemize{
\item Output columns are: \code{rule_nbr}, \code{LHS}, \code{RHS}, \code{support}.
\item The rules are sorted in this order: \code{desc(support)}.
}
}
\examples{
model_class_rpart = rpart::rpart(Species ~ ., data = iris)
tidy(model_class_rpart)

model_regr_rpart = rpart::rpart(Sepal.Length ~ ., data = iris)
tidy(model_regr_rpart)

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}

Other Core Tidy Utility: 
\code{\link{tidy}()},
\code{\link{tidy.C5.0}()},
\code{\link{tidy.cubist}()}
}
\concept{Core Tidy Utility}
