% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_noise_cat_unif.R
\name{add_noise_cat_unif}
\alias{add_noise_cat_unif}
\title{Inject noise into a categorical random variable by mixing a sample of uniform
records into the predictions.}
\usage{
add_noise_cat_unif(
  model,
  new_data,
  conf_model_data,
  outcome_var,
  col_schema,
  pred,
  unif_prop,
  resample_props = NULL,
  observed_levels = FALSE
)
}
\arguments{
\item{model}{A \code{model_spec} or a list of \code{model_spec}s from \code{library(parsnip)}}

\item{new_data}{A data frame used to generate predictions}

\item{conf_model_data}{A data frame for estimating the predictive model}

\item{outcome_var}{A string name representing the outcome variable}

\item{col_schema}{A list of column schema specifications for the new variable}

\item{pred}{A vector of values predicted by the model}

\item{unif_prop}{A proportion of records to resample with uniform noise}

\item{resample_props}{An optional named vector of probabilities for resampling,
defaults to uniform over all levels supplied in \code{col_schema}.}

\item{observed_levels}{An optional Boolean to only resample from observed levels
in the confidential data.}
}
\value{
A numeric vector with noise added to each prediction
}
\description{
Inject noise into a categorical random variable by mixing a sample of uniform
records into the predictions.
}
\examples{

conf_model_data <- mtcars|>
  dplyr::mutate(gear = factor(.data[["gear"]]))

col_schema <- list(
  "dtype" = "fct",
  "levels" = c("3", "4", "5"),
  "na_prop" = 0
)

add_noise_cat_unif(
  model = conf_model_data,
  new_data = NULL,
  conf_model_data = NULL,
  outcome_var = "gear",
  col_schema = col_schema,
  pred = factor(c(rep("3", 10), rep("4", 10), rep("5", 10))),
  unif_prop = 0.5
)

}
