% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presynth.R
\name{print.presynth}
\alias{print.presynth}
\title{print method for presynth objects}
\usage{
\method{print}{presynth}(x, ...)
}
\arguments{
\item{x}{A \code{presynth} object}

\item{...}{further arguments passed to or from other methods (not currently
used).}
}
\value{
A \code{presynth} object
}
\description{
print method for presynth objects
}
\examples{

# create roadmap
rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
) 

rpart_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

rpart_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

synth_spec1 <- synth_spec(
  default_regression_model = rpart_mod_reg,
  default_regression_sampler = sample_rpart,
  default_classification_model = rpart_mod_class,
  default_classification_sampler = sample_rpart
)

# create a presynth object
# use defaults for noise, constraints, and replicates
presynth <- presynth(
  roadmap = rm,
  synth_spec = synth_spec1
)

print(presynth)

}
