% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reframe.R
\name{reframe}
\alias{reframe}
\title{Reframe a data frame}
\usage{
reframe(.df, ..., .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{.by}{Columns to group by}
}
\description{
Reframe a data frame. Note this is a simple alias for \code{summarize()}
that always returns an ungrouped tidytable.
}
\examples{
mtcars \%>\%
  reframe(qs = quantile(disp, c(0.25, 0.75)),
          prob = c(0.25, 0.75),
          .by = cyl)
}
