% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-sf.R
\name{as_sf}
\alias{as_sf}
\title{Coerce a \code{SpatVector} to a \code{\link[sf:sf]{sf}} object}
\usage{
as_sf(x, ...)
}
\arguments{
\item{x}{A \code{SpatVector}.}

\item{...}{additional arguments passed on to \code{\link[sf:st_as_sf]{sf::st_as_sf()}}.}
}
\value{
A \code{\link[sf:sf]{sf}} object object with an additional \code{tbl_df} class, for
pretty printing method.
}
\description{
\code{\link[=as_sf]{as_sf()}} turns a \code{SpatVector} to \code{\link[sf:sf]{sf}} object. This is a wrapper
of \code{\link[sf:st_as_sf]{sf::st_as_sf()}} with the particularity that the groups created with
\code{\link[=group_by.SpatVector]{group_by.SpatVector()}} are preserved.
}
\examples{

library(terra)

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")
v <- terra::vect(f)

# This is ungrouped
v
is_grouped_spatvector(v)

# Get an ungrouped data
a_sf <- as_sf(v)

dplyr::is_grouped_df(a_sf)

# Grouped

v$gr <- c("C", "A", "A", "B", "A", "B", "B")
v$gr2 <- rep(c("F", "G", "F"), 3)

gr_v <- group_by(v, gr, gr2)

gr_v
is_grouped_spatvector(gr_v)

group_data(gr_v)

# A sf

a_gr_sf <- as_sf(gr_v)

dplyr::is_grouped_df(a_gr_sf)

group_data(a_gr_sf)

}
\seealso{
Coercing objects:
\code{\link{as_coordinates}()},
\code{\link{as_spatraster}()},
\code{\link{as_spatvector}()},
\code{\link{as_tibble.Spat}},
\code{\link{fortify.Spat}},
\code{\link{tidy.Spat}}
}
\concept{coerce}
