% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{char2factor}
\alias{char2factor}
\title{Convert character variable to a factor based off it's numeric variable
counterpart.}
\usage{
char2factor(df, c_var, n_var)
}
\arguments{
\item{df}{data frame.}

\item{c_var}{character variable within the data frame.}

\item{n_var}{numeric variable counter part within the data frame to control
the levels.}
}
\value{
A factor.
}
\description{
Convert character variable to a factor based off it's numeric variable
counterpart.
}
\examples{
df <- tibble::tribble(
  ~TRT01P, ~TRT01PN,
  "Placebo", 1,
  "Low Dose", 2,
  "High Dose", 3
)

# alphabetical order
dplyr::arrange(df, TRT01P)

# change to factor with char2factor
df$TRT01P <- char2factor(df, "TRT01P", "TRT01PN")

# factor order
dplyr::arrange(df, TRT01P)
}
