test_that("prep_tt_curate creates the directory", {
  skip_on_ci()
  proj_dir <- withr::local_tempdir()
  usethis::local_project(proj_dir, force = TRUE, quiet = TRUE)
  full_submission_path <- usethis::proj_path("tt_submission")
  test_result <- prep_tt_curate()
  expect_equal(test_result, full_submission_path)
})

test_that("prep_tt_curate works with ignore", {
  skip_on_ci()
  proj_dir <- withr::local_tempdir()
  usethis::local_project(proj_dir, force = TRUE, quiet = TRUE)
  full_submission_path <- usethis::proj_path("tt_submission")
  test_result <- prep_tt_curate(ignore = TRUE)
  expect_equal(test_result, full_submission_path)
  ignore_path <- fs::path(proj_dir, ".Rbuildignore")
  expect_true(fs::file_exists(ignore_path))
  ignore_contents <- readLines(ignore_path)
  expect_true(grepl(full_submission_path, ignore_contents))
})
