% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{predcorrect}
\alias{predcorrect}
\alias{predcorrect.tidyvpcobj}
\title{Prediction corrected Visual Predictive Check (pcVPC)}
\usage{
predcorrect(o, ...)

\method{predcorrect}{tidyvpcobj}(o, pred, data = o$data, ..., log = FALSE, varcorr = FALSE)
}
\arguments{
\item{o}{A `tidyvpcobj`.}

\item{...}{Other arguments to include.}

\item{pred}{Prediction variable in observed data.}

\item{data}{Observed data supplied in `observed()` function.}

\item{log}{Logical indicating whether DV was modeled in logarithmic scale.}

\item{varcorr}{Logical indicating whether variability correction should be
applied for prediction corrected dependent variable}
}
\value{
Updates `tidyvpcobj` with required information to perform prediction
  correction, which includes the `predcor` logical indicating whether
  prediction corrected VPC is to be performed, the `predcor.log` logical
  indicating whether the DV is on a log-scale, the `varcorr` logical
  indicating whether variability correction for prediction corrected
  dependent variable is applied and the `pred` prediction column from the
  original data. Both `obs` and `sim` data tables in the returned
  `tidyvpcobj` object have additional `ypc` column with the results of
  prediction correction and `ypcvc` column if variability correction is
  requested.
}
\description{
Specify prediction variable for pcVPC.
}
\examples{
\donttest{
require(magrittr)

obs_data <- obs_data[MDV == 0]
sim_data <- sim_data[MDV == 0]

 # Add PRED variable to observed data from first replicate of
 # simulated data

obs_data$PRED <- sim_data[REP == 1, PRED]

  vpc <- observed(obs_data, x=TIME, yobs=DV) \%>\%
       simulated(sim_data, ysim=DV) \%>\%
       binning(bin = NTIME) \%>\%
       predcorrect(pred=PRED, varcorr = TRUE) \%>\%
       vpcstats()

 # For binless loess prediction corrected, use predcorrect() before
 # binless() and set loess.ypc = TRUE

  vpc <- observed(obs_data, x=TIME, yobs=DV) \%>\%
       simulated(sim_data, ysim=DV) \%>\%
       predcorrect(pred=PRED) \%>\%
       binless() \%>\%
       vpcstats()
       }

}
\seealso{
\code{\link{observed}} \code{\link{simulated}}
  \code{\link{censoring}} \code{\link{stratify}} \code{\link{binning}}
  \code{\link{binless}} \code{\link{vpcstats}}
}
