% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_helpers.R
\name{rename_helpers}
\alias{balance_ions_chain}
\alias{biofilter_toc_chain}
\alias{blend_waters_chain}
\alias{chemdose_chloramine_chain}
\alias{chemdose_chlordecay_chain}
\alias{chemdose_dbp_chain}
\alias{chemdose_ph_chain}
\alias{chemdose_toc_chain}
\alias{define_water_chain}
\alias{decarbonate_ph_chain}
\alias{modify_water_chain}
\alias{ozonate_bromate_chain}
\alias{pac_toc_chain}
\alias{calculate_corrosion_once}
\alias{chemdose_dbp_once}
\alias{chemdose_ph_once}
\alias{chemdose_toc_once}
\alias{define_water_once}
\alias{dissolve_cu_once}
\alias{dissolve_pb_once}
\alias{solvect_chlorine_once}
\alias{solvect_o3_once}
\alias{solvedose_alk_once}
\alias{solvedose_ph_once}
\alias{solveresid_o3_once}
\title{Functions renamed in tidywater 0.10.0}
\usage{
balance_ions_chain(
  df,
  input_water = "defined_water",
  output_water = "balanced_water",
  anion = "cl",
  cation = "na"
)

biofilter_toc_chain(
  df,
  input_water = "defined_water",
  output_water = "biofiltered_water",
  ebct = "use_col",
  ozonated = "use_col"
)

blend_waters_chain(df, waters, ratios, output_water = "blended_water")

chemdose_chloramine_chain(
  df,
  input_water = "defined_water",
  output_water = "chlorinated_water",
  time = "use_col",
  cl2 = "use_col",
  nh3 = "use_col",
  use_free_cl_slot = "use_col",
  use_tot_nh3_slot = "use_col"
)

chemdose_chlordecay_chain(
  df,
  input_water = "defined_water",
  output_water = "disinfected_water",
  cl2_dose = "use_col",
  time = "use_col",
  treatment = "use_col",
  cl_type = "use_col",
  use_chlorine_slot = "use_col"
)

chemdose_dbp_chain(
  df,
  input_water = "defined_water",
  output_water = "disinfected_water",
  cl2 = "use_col",
  time = "use_col",
  treatment = "use_col",
  cl_type = "use_col",
  location = "use_col",
  correction = TRUE,
  coeff = NULL
)

chemdose_ph_chain(
  df,
  input_water = "defined_water",
  output_water = "dosed_chem_water",
  hcl = "use_col",
  h2so4 = "use_col",
  h3po4 = "use_col",
  hno3 = "use_col",
  co2 = "use_col",
  naoh = "use_col",
  na2co3 = "use_col",
  nahco3 = "use_col",
  caoh2 = "use_col",
  mgoh2 = "use_col",
  caocl2 = "use_col",
  cacl2 = "use_col",
  cl2 = "use_col",
  naocl = "use_col",
  nh4oh = "use_col",
  nh42so4 = "use_col",
  caco3 = "use_col",
  caso4 = "use_col",
  alum = "use_col",
  ferricchloride = "use_col",
  ferricsulfate = "use_col",
  ach = "use_col",
  kmno4 = "use_col",
  naf = "use_col",
  na3po4 = "use_col",
  softening_correction = "use_col",
  na_to_zero = TRUE
)

chemdose_toc_chain(
  df,
  input_water = "defined_water",
  output_water = "coagulated_water",
  alum = "use_col",
  ferricchloride = "use_col",
  ferricsulfate = "use_col",
  coeff = "use_col"
)

define_water_chain(df, output_water = "defined_water")

decarbonate_ph_chain(
  df,
  input_water = "defined_water",
  output_water = "decarbonated_water",
  co2_removed = "use_col"
)

modify_water_chain(
  df,
  input_water = "defined_water",
  output_water = "modified_water",
  slot = "use_col",
  value = "use_col",
  units = "use_col"
)

ozonate_bromate_chain(
  df,
  input_water = "defined_water",
  output_water = "ozonated_water",
  dose = "use_col",
  time = "use_col",
  model = "use_col"
)

pac_toc_chain(
  df,
  input_water = "defined_water",
  output_water = "pac_water",
  dose = "use_col",
  time = "use_col",
  type = "use_col"
)

calculate_corrosion_once(
  df,
  input_water = "defined_water",
  index = c("aggressive", "ryznar", "langelier", "ccpp", "larsonskold", "csmr"),
  form = "calcite"
)

chemdose_dbp_once(
  df,
  input_water = "defined_water",
  cl2 = "use_col",
  time = "use_col",
  treatment = "use_col",
  cl_type = "use_col",
  location = "use_col",
  correction = TRUE,
  coeff = NULL,
  water_prefix = TRUE
)

chemdose_ph_once(
  df,
  input_water = "defined_water",
  hcl = "use_col",
  h2so4 = "use_col",
  h3po4 = "use_col",
  hno3 = "use_col",
  co2 = "use_col",
  naoh = "use_col",
  na2co3 = "use_col",
  nahco3 = "use_col",
  caoh2 = "use_col",
  mgoh2 = "use_col",
  caocl2 = "use_col",
  cacl2 = "use_col",
  cl2 = "use_col",
  naocl = "use_col",
  nh4oh = "use_col",
  nh42so4 = "use_col",
  caco3 = "use_col",
  caso4 = "use_col",
  alum = "use_col",
  ferricchloride = "use_col",
  ferricsulfate = "use_col",
  ach = "use_col",
  kmno4 = "use_col",
  naf = "use_col",
  na3po4 = "use_col"
)

chemdose_toc_once(
  df,
  input_water = "defined_water",
  output_water = "coagulated_water",
  alum = "use_col",
  ferricchloride = "use_col",
  ferricsulfate = "use_col",
  coeff = "use_col"
)

define_water_once(df)

dissolve_cu_once(df, input_water = "defined_water")

dissolve_pb_once(
  df,
  input_water = "defined_water",
  output_col_solid = "controlling_solid",
  output_col_result = "pb",
  hydroxypyromorphite = "Schock",
  pyromorphite = "Topolska",
  laurionite = "Nasanen",
  water_prefix = TRUE
)

solvect_chlorine_once(
  df,
  input_water = "defined_water",
  time = "use_col",
  residual = "use_col",
  baffle = "use_col",
  free_cl_slot = "residual_only",
  water_prefix = TRUE
)

solvect_o3_once(
  df,
  input_water = "defined_water",
  time = "use_col",
  dose = "use_col",
  kd = "use_col",
  baffle = "use_col",
  water_prefix = TRUE
)

solvedose_alk_once(
  df,
  input_water = "defined_water",
  output_column = "dose_required",
  target_alk = "use_col",
  chemical = "use_col"
)

solvedose_ph_once(
  df,
  input_water = "defined_water",
  output_column = "dose_required",
  target_ph = "use_col",
  chemical = "use_col"
)

solveresid_o3_once(
  df,
  input_water = "defined_water",
  output_column = "o3resid",
  dose = "use_col",
  time = "use_col"
)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

tidywater 0.10.0 renamed several helper functions to simplify naming and match tidyverse conventions
\itemize{
\item \verb{_chain} -> \verb{_df}
\item For functions that return a water: \verb{_once} -> \verb{_df(pluck_cols = TRUE)}
\item For functions with numeric outputs: \verb{_once} -> \verb{_df()}
}
}
\keyword{internal}
