% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_extract.R
\name{tw_extract_qualifier}
\alias{tw_extract_qualifier}
\title{Extract qualifiers from a list created with \code{\link[=tw_get_item]{tw_get_item()}}}
\usage{
tw_extract_qualifier(id, p, w = NULL)
}
\arguments{
\item{id}{A character vector of length 1, must start with Q, e.g. "Q254" for
Wolfgang Amadeus Mozart.}

\item{p}{A character vector of length 1, a property. Must always start with
the capital letter "P", e.g. "P31" for "instance of".}

\item{w}{A list, typically created with \code{\link[=tw_get_item]{tw_get_item()}}}
}
\value{
A data frame (a tibble) with eight columns: \code{id} for the input id,
\code{property},  \code{qualifier_id}, \code{qualifier_property}, \code{qualifier_value},
\code{rank}, \code{qualifier_value_type}, and \code{set} (to distinguish sets of data when
a property is present more than once)
}
\description{
This function is mostly used internally and for testing.
}
\examples{
# w <- tw_get_item(id = "Q180099")

tw_extract_qualifier(id = "Q180099", p = "P26", w = list(tw_test_items[["Q180099"]]))
}
