% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.TwoSampleKaplanMeier}
\alias{print.TwoSampleKaplanMeier}
\title{Print function for object of class 'TwoSampleKaplanMeier'}
\usage{
\method{print}{TwoSampleKaplanMeier}(x, digits = 4, what = "all", method = NULL, ...)
}
\arguments{
\item{x}{an object of class 'TwoSampleKaplanMeier'}

\item{digits}{number of digits to print the results}

\item{what}{either "SR", "RR", "Diff" or "all" (default), depending on whether we want to print the results for the survival ratio (SR), the risk ratio (RR), the risk difference (Diff) or all of them.}

\item{method}{either "EL", "Wald" or "both", depending on whether we want to print the results obtained when using empirical likelihood inference (EL), Wald-type inference (Wald) or both. Default is 'NULL', which means that 'method' inherits the value of the corresponding control parameter used when creating the object 'x'.}

\item{...}{Not used}
}
\value{
no return value, called for printing only.
}
\description{
Print function for object of class 'TwoSampleKaplanMeier'
}
\examples{
# This example reproduces some results presented in Table 4 of Thomas and Grunkemeier (1975)
Res2SKM95 <- TwoSampleKaplanMeier(time=Freireich$time,
                                  status=Freireich$status,
                                  group=Freireich$group,
                                  t=10)
print(Res2SKM95, digits=3, what="SR", method="EL")

}
\author{
Paul Blanche
}
