% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalization.R
\name{get_my_top_artists_or_tracks}
\alias{get_my_top_artists_or_tracks}
\title{Get the current user’s top artists or tracks based on calculated affinity.}
\usage{
get_my_top_artists_or_tracks(
  type = NULL,
  limit = 20,
  offset = 0,
  time_range = "medium_term",
  authorization = get_spotify_authorization_code(),
  include_meta_info = FALSE
)
}
\arguments{
\item{type}{Required. The type of entity to return. Valid values: \code{artists} or \code{tracks}.}

\item{limit}{Optional. \cr
Maximum number of results to return. \cr
Default: 20 \cr
Minimum: 1 \cr
Maximum: 50 \cr}

\item{offset}{Optional. \cr
The index of the first entity to return. \cr
Default: 0 (i.e., the first track). \cr
Use with limit to get the next set of entities.}

\item{time_range}{Optional. Over what time frame the affinities are computed. Valid values: long_term (calculated from several years of data and including all new data as it becomes available), \code{medium_term} (approximately last 6 months), \code{short_term} (approximately last 4 weeks). Default: \code{medium_term}.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing track or album data. See the official API \href{https://developer.spotify.com/documentation/web-api/reference/personalization/get-users-top-artists-and-tracks/}{documentation} for more information.
}
\description{
Get the current user’s top artists or tracks based on calculated affinity.
}
