% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_irt.R
\name{sim_irt}
\alias{sim_irt}
\title{Simulate Item Response Theory Data}
\usage{
sim_irt(
  n_people = 1000,
  item_structure = list(),
  theta = NULL,
  theta_mean = 0,
  theta_sd = 1
)
}
\arguments{
\item{n_people}{Integer. Number of students.}

\item{item_structure}{List of lists defining item blocks.}

\item{theta}{Numeric vector (Optional). If provided, these exact ability values are used.}

\item{theta_mean}{Numeric. Mean of latent trait (used if theta is NULL).}

\item{theta_sd}{Numeric. SD of latent trait (used if theta is NULL).}
}
\value{
A list containing:
\item{resp}{data.frame of responses (rows=people, cols=items)}
\item{true_params}{data.frame of true item parameters}
\item{theta}{vector of true latent traits}
}
\description{
Simulate item responses data. Support both dichotomous and polytomous responses.
Provide an easy implementation with a few default settings.
}
\examples{
  # 1. Define the Test Blueprint
  # We want:
  # - 10 items using 2PL (medium difficulty)
  # - 5 items using 3PL (difficult, with guessing)
  # - 5 items using GPCM (4-point Likert scale)
  # - 5 items using GRM (5-point Likert scale)

  my_test_structure <- list(
    # Block 1: 2PL
    list(model = "2PL", n_items = 10, a = c(0.8, 1.2), b = c(-1, 1)),

    # Block 2: 3PL (Harder items, b from 1 to 2.5, fixing guessing at 0.2)
    list(model = "3PL", n_items = 5, a = c(1.0, 1.5), b = c(1.0, 2.5), c = 0.2),

    # Block 3: GPCM (Polytomous, 4 categories 0-3)
    list(model = "GPCM", n_items = 5, categories = 4, a = c(0.7, 1.3), b = c(-1, 1)),

    # Block 4: GRM (Polytomous, 5 categories 0-4)
    list(model = "GRM", n_items = 5, categories = 5, a = c(1.0, 2.0))
  )

  # 2. Run the Simulation
  # Define N and a specific Theta vector
  N <- 2000
  theta_vec <- rnorm(N, 0, 2)

  sim_data <- sim_irt(
    n_people = N,
    theta = theta_vec,
    item_structure = my_test_structure
  )

  # 3. Inspect the Output
  # The Response Matrix
  head(sim_data$resp)

  # The True Parameters (Useful for recovery studies)
  # Note how it aligns a, b, and threshold parameters (step_1, step_2...)
  head(sim_data$true_params)
}
