% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{editor-shiny}
\alias{editor-shiny}
\alias{editorOutput}
\alias{renderEditor}
\title{Shiny bindings for \code{\link[=editor]{editor()}}}
\usage{
editorOutput(outputId, width = "100\%", height = "600px")

renderEditor(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{Output variable to read from.}

\item{width, height}{Must be a valid CSS unit (like \verb{100\%},
\verb{400px}, \code{auto}) or a number, which will be coerced to a
string and have \code{px} appended.}

\item{expr}{An expression that generates a calendar}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
Output element that can be included in UI. Render function to create output in server.
}
\description{
Output and render functions for using \code{\link[=editor]{editor()}} within Shiny
applications and interactive Rmd documents.
}
\examples{

library(shiny)
library(toastui)

ui <- fluidPage(
  tags$h2("editor shiny example"),
  tabsetPanel(
    tabPanel(
      title = "Default",
      editorOutput("default"),
      tags$b("CHECK HEIGHT")
    ),
    tabPanel(
      title = "WYSIWYG",
      editorOutput("wysiwyg"),
      tags$b("CHECK HEIGHT")
    ),
    tabPanel(
      title = "Vertical",
      editorOutput("vertical"),
      tags$b("CHECK HEIGHT")
    )
  )
)

server <- function(input, output, session) {
  
  output$default <- renderEditor({
    editor(minHeight = "400px")
  })
  
  output$wysiwyg <- renderEditor({
    editor(initialEditType = "wysiwyg", hideModeSwitch = TRUE)
  })
  
  output$vertical <- renderEditor({
    editor(previewStyle = "vertical")
  })
  
}

if (interactive())
  shinyApp(ui, server)
}
