% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjusted_coefficient_of_variation.R
\name{adjusted_coefficient_of_variation}
\alias{adjusted_coefficient_of_variation}
\title{Adjusted coefficient of variaiton}
\usage{
adjusted_coefficient_of_variation(data, trait, genotype, environment)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analyzed.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}
}
\value{
a data table with adjusted coefficient of variation
}
\description{
\code{adjusted_coefficient_of_variation} calculate variance of a genotype across environments.
}
\details{
Adjusted coefficient of variaiton (Doering and Reckling, 2018) is calculatd based on regression function.
Variety with low adjusted coefficient of variation is considered as stable. Equation of adjusted coefficient of variation can be found in vignette file.
}
\examples{
data(Data)
res <- adjusted_coefficient_of_variation(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment")
}
\references{
\insertRef{doering2018}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{approach}
\keyword{regression}
