% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_of_determination.R
\name{coefficient_of_determination}
\alias{coefficient_of_determination}
\title{Coefficient of determination}
\usage{
coefficient_of_determination(data, trait, genotype, environment)
}
\arguments{
\item{data}{a dataframe containing trait, genotype and environment.}

\item{trait}{colname of a column containing a numeric vector of interested trait to be analysized.}

\item{genotype}{colname of a column containing a character or factor vector labeling different genotypic varieties}

\item{environment}{colname of a column containing a character or factor vector labeling different environments}
}
\value{
a data table with coefficient of determination
}
\description{
\code{coefficient_of_determination} calculate variance of a genotype across environments.
}
\details{
Coefficient of determination (Pinthus, 1976) is calculatd based on regression function.
Variety with low coefficient of determination is considered as stable.
Equation of coefficient of determination can be found in vignette file.
}
\examples{
data(Data)
coef.of.determination <- coefficient_of_determination(
 data = Data,
 trait = "Yield",
 genotype = "Genotype",
 environment = "Environment")
}
\references{
\insertRef{pinthus1973}{toolStability}
}
\author{
Tien-Cheng Wang
}
\keyword{approach}
\keyword{regression}
