% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_df.R
\name{as_tabular_toon}
\alias{as_tabular_toon}
\title{Convert array-of-objects to tabular representation}
\usage{
as_tabular_toon(x, strict = TRUE, warn = TRUE)
}
\arguments{
\item{x}{List of lists/named lists (array of objects).}

\item{strict}{Logical. If TRUE (default), validate input structure.}

\item{warn}{Logical. If TRUE (default), emit warnings for type promotions.}
}
\value{
A data.frame suitable for \code{write_toon_df()}.
}
\description{
Convert array-of-objects to tabular representation
}
\details{
In permissive mode:
\itemize{
\item Union schema across all records
\item Missing fields filled with NA
\item Type promotion to accommodate all values
}
}
\examples{
# Convert array of objects to data.frame
records <- list(
  list(name = "Alice", age = 30),
  list(name = "Bob", age = 25)
)
df <- as_tabular_toon(records)

}
