% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.lm_topic_labels.R
\name{as.lm_topic_labels}
\alias{as.lm_topic_labels}
\alias{is.lm_topic_labels}
\title{lm_topic_labels object}
\usage{
as.lm_topic_labels(
  x,
  terms,
  prompts,
  model,
  params,
  with_token,
  time,
  model_output,
  labels
)

is.lm_topic_labels(obj, verbose = FALSE)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link[topiclabels:as.lm_topic_labels]{lm_topic_labels}} object. Alternatively each element can be passed for
individual results. Individually set elements overwrite elements from \code{x}.}

\item{terms}{[\code{list(n) of character}]\cr
List of \code{character} vectors, whereas each vector represents the top terms
of a topic. Topics may consist of different numbers of top terms.}

\item{prompts}{[\code{character(n)}]\cr
Optional.\cr
Each entry of the \code{character} vector contains the original prompt that
was used to obtain the corresponding entry of \code{model_output}.}

\item{model}{[\code{character(1)}]\cr
The language model used for labeling the topics.}

\item{params}{[\code{named list}]\cr
Optional.\cr
Model parameters passed.}

\item{with_token}{[\code{logical(1)}]\cr
Optional.\cr
Was the labeling executed using a Huggingface token?}

\item{time}{[\code{numeric(1)}]\cr
Optional.\cr
Time needed for the labeling.}

\item{model_output}{[\code{character(n)}]\cr
Optional.\cr
Each entry of the \code{character} vector contains the original model output
obtained using the corresponding prompt from \code{prompts}.}

\item{labels}{[\code{character(n)}]\cr
The extracted labels from \code{model_output}.}

\item{obj}{[\code{R} object]\cr
Object to test.}

\item{verbose}{[\code{logical(1)}]\cr
Should test information be given in the console?}
}
\value{
[\code{named list}] \code{\link[topiclabels:as.lm_topic_labels]{lm_topic_labels}} object.
}
\description{
Constructor for lm_topic_labels objects used in this package.
}
\details{
If you call \code{as.lm_topic_labels} on an object \code{x} which already is of
the structure of a \code{lm_topic_labels} object (in particular a \code{lm_topic_labels}
object itself), the additional arguments \code{id, param, ...}
may be used to override the specific elements.
}
\examples{
\dontrun{
token = "" # please insert your hf token here
topwords_matrix = matrix(c("zidane", "figo", "kroos",
                           "gas", "power", "wind"), ncol = 2)
obj = label_topics(topwords_matrix, token = token)
obj$model
obj_modified = as.lm_topic_labels(obj, model = "It is possible to modify individual entries")
obj_modified$model

obj_modified$model = 3.5 # example for an invalid modification
is.lm_topic_labels(obj_modified, verbose = TRUE)

obj_manual = as.lm_topic_labels(terms = list(c("zidane", "figo", "kroos"),
                                             c("gas", "power", "wind")),
                                model = "manual labels",
                                labels = c("Football Players", "Energy Supply"))
}
}
