% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{make_interactive}
\alias{make_interactive}
\title{Create Interactive Plot}
\usage{
make_interactive(plot, tooltip_vars = NULL)
}
\arguments{
\item{plot}{ggplot object to convert}

\item{tooltip_vars}{Vector of variable names to include in tooltips}
}
\value{
A \code{plotly} object with interactive features.
}
\description{
Converts a static ggplot visualization to an interactive plotly visualization
with customizable tooltips and interactive features.
}
\details{
The function enhances static plots by adding:
\itemize{
\item Hover tooltips with data values
\item Zoom capabilities
\item Pan capabilities
\item Click interactions
\item Double-click to reset
}

If tooltip_vars is NULL, the function attempts to automatically determine
relevant variables from the plot's mapping.
}
\examples{
if (interactive() && requireNamespace("plotly", quietly = TRUE)) {
# Create sample data and plot
data <- data.frame(
  V1 = rnorm(100), V2 = rnorm(100), name=1:100,
  antigen = rep(c(0,1), 50), antiserum = rep(c(1,0), 50),
  year = rep(2000:2009, each=10), cluster = rep(1:5, each=20)
)

# Create temporal plot
p1 <- plot_temporal_mapping(data, ndim=2)

# Make interactive with default tooltips
p1_interactive <- make_interactive(p1)

# Create cluster plot with custom tooltips
p2 <- plot_cluster_mapping(data, ndim=2)
p2_interactive <- make_interactive(p2,
  tooltip_vars = c("cluster", "year", "antigen")
)
}
}
