#' Extract components of a tally
#'
#' Decomposes the tally into stronly connected components.
#' @param tally a \code{toporanga_tally} object.
#' @returns A vector of component IDs for each agent, named with agent IDs.
#' Components are integers from 1 up to the component count, which is at most the number of agents.
#' Hence, when the tally is fully strongly connected, the result is a vector of ones.
#' @export

components<-function(tally){
  m<-matrix_tally(tally)
  .Call(C_scc,m>0)->cmp
  stats::setNames(cmp,colnames(m))
}



