test_that("tally_log errors when needed",{
  expect_error(
    tally_log(1:3,c(2,3,1),agents="1"),
    "Event log includes agents not given by agents argument: 2, 3"
  )
})

test_that("ghost agent works with list_tally",{
  ag<-c("1","2","3","Ghost")
  tally_log(1:3,c(2,3,1),agents=ag)->Q
  list_tally(Q)->Q
  expect_identical(levels(Q$a),ag)
  expect_identical(levels(Q$b),ag)
})

test_that("ghost agent works with enforce_cyclicity",{
  tally_log(1:3,c(2,3,1),agents=c("1","2","3","Ghost"))->Q
  arrange(Q)->G
  expect_true(all(!G$m["Ghost",]))
  expect_true(all(!G$m[,"Ghost"]))
})

test_that("ghost agent won't normalise to NaN",{
  tally_log(1:3,c(2,3,1),agents=c("1","2","3","Ghost"))->Q
  expect_true(all(is.finite(normalise(Q)$m)))
})
