% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-fcn.R
\name{model_fcn_resnet}
\alias{model_fcn_resnet}
\alias{model_fcn_resnet50}
\alias{model_fcn_resnet101}
\title{Fully Convolutional Network for Semantic Segmentation}
\usage{
model_fcn_resnet50(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 21,
  aux_loss = NULL,
  pretrained_backbone = TRUE,
  ...
)

model_fcn_resnet101(
  pretrained = FALSE,
  progress = TRUE,
  num_classes = 21,
  aux_loss = NULL,
  pretrained_backbone = TRUE,
  ...
)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{num_classes}{Number of output classes. Default: 21.}

\item{aux_loss}{If TRUE, includes the auxiliary classifier. If NULL, defaults to TRUE when \code{pretrained = TRUE}.}

\item{pretrained_backbone}{If TRUE, uses a backbone pre-trained on ImageNet.}

\item{...}{Additional arguments passed to the backbone implementation.}
}
\value{
An \code{nn_module} representing the FCN model.
}
\description{
Constructs an FCN (Fully Convolutional Network) model for semantic image segmentation,
based on a ResNet backbone as described in
\href{https://arxiv.org/abs/1411.4038}{Fully Convolutional Networks for Semantic Segmentation}.
}
\details{
The 21 output classes follow the PASCAL VOC convention:
\code{background}, \code{aeroplane}, \code{bicycle}, \code{bird}, \code{boat},
\code{bottle}, \code{bus}, \code{car}, \code{cat}, \code{chair},
\code{cow}, \verb{dining table}, \code{dog}, \code{horse}, \code{motorbike},
\code{person}, \verb{potted plant}, \code{sheep}, \code{sofa}, \code{train},
\code{tv/monitor}.

Pretrained weights require \code{num_classes = 21}.
}
\examples{
\dontrun{
library(magrittr)
norm_mean <- c(0.485, 0.456, 0.406) # ImageNet normalization constants, see
# https://pytorch.org/vision/stable/models.html
norm_std  <- c(0.229, 0.224, 0.225)
img_url <- "https://en.wikipedia.org/wiki/Special:FilePath/Felis_catus-cat_on_snow.jpg"
img <- base_loader(img_url)

input <- img \%>\%
 transform_to_tensor() \%>\%
 transform_resize(c(520, 520)) \%>\%
 transform_normalize(norm_mean, norm_std)
batch <- input$unsqueeze(1)

model <- model_fcn_resnet50(pretrained = TRUE)
model$eval()
output <- model(batch)

# visualize the result
# `draw_segmentation_masks()` turns the torch_float output into a boolean mask internaly:
segmented <- draw_segmentation_masks(input, output$out$squeeze(1))
tensor_image_display(segmented)


model <- model_fcn_resnet101(pretrained = TRUE)
model$eval()
output <- model(batch)

# visualize the result
segmented <- draw_segmentation_masks(input, output$out$squeeze(1))
tensor_image_display(segmented)
}
}
\seealso{
Other semantic_segmentation_model: 
\code{\link{model_deeplabv3}}
}
\concept{semantic_segmentation_model}
