################################################################################
# Returns s truncated to length width, and, if necessary padded with spaces to 
# the left and right so that the string is exactly width wide.
# Author: Alexis Dinno
# Date: Sep 22, 2024
# Takes: A string s, and a positive integer width.
pad.center <- function(s, width) {
	 s <- sub("^0+", "", s)
	 s <- sub("-0.", "-.", s)
  len.s <- nchar(s)
  if (len.s < width) {
    right <- ((width - len.s) %/% 2) + ((width - len.s) %% 2)
    left  <- (width - len.s) %/% 2
    s <- paste0(pad.spaces(left),s,pad.spaces(right))
    }
  return(substr(s,1,width))
  }
