\encoding{utf8}
\name{tost.regress}
\alias{Linear regression tests for equivalence}
\alias{tost.regress}
\concept{Linear regression tests for equivalence}
\concept{Two One-Sided Tests}
\title{Linear regression tests for equivalence}
\description{
 \loadmathjax
 Performs linear regression tests for equivalencee}
\usage{
tost.regress(
  formula, 
  data        = NULL, 
  eqv.type    = equivalence.types, 
  eqv.level   = 1, 
  upper       = NA, 
  conf.level  = 0.95, 
  relevance   = TRUE)

equivalence.types
#c("delta", "epsilon")
}
\arguments{
 \item{formula}{an object of class "\link{formula}" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under 'Details'.}
 \item{data}{an optional data frame, list or environment (or object coercible by \link{as.data.frame} to a data frame) containing the variables in the model. If not found in data, the variables are taken from \code{environment(formula)}, typically the environment from which \code{lm} is called.}
 \item{eqv.type}{either a single string (\code{"delta"}, or \code{"epsilon"}), or a vector of strings---one for each regression coefficient estimated; the first applying to the model constant term, and the remaining to each model variable in \code{formula} in order---which specifies whether the equivalence interval will be defined in terms of \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}. If a single string, then each coefficient's equivalence region will use that definition. These options change the way that \code{evq.level} is interpreted: when \code{"delta"} is specified, the \code{evq.level} is measured in the units of the variable(s) being tested, and when \code{"epsilon"} is specified, the \code{evq.level} is measured in units of the \emph{t} distribution; put another way \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}. The default is \code{"delta"}.\cr \cr Defining tolerance in terms of \mjeqn{\varepsilon}{epsilon} means that it is not possible to reject any test for mean equivalence's \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\varepsilon \le t_{\nu,\alpha}}{epsilon <= the critical value of \emph{t} for a given alpha and degrees of freedom}. Because \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}, we can see that it is not possible to reject any \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\Delta \le \text{standard error} \times t_{\nu,\alpha}}{Delta <= the product of the standard error and critical value of \emph{t} for a given alpha and degrees of freedom}. \code{tost.regress} reports when either of these conditions obtain.}
 \item{eqv.level}{either a single numerical value, or a vector of numerical values---one for each regression coefficient estimated---defines the equivalence threshold for the tests depending on whether \code{eqv.type} is \code{"delta"} or \code{"epsilon"} (see \code{eqv.type} above). If a single value, then each coefficient's equivalence region will use that level. Researchers are responsible for choosing meaningful values of \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}. The default value is 1.}
 \item{upper}{either a single numerical value, or a vector of numerical values---one for each regression coefficient estimated---which defines the upper equivalence threshold for a coefficient's equivalence interval; is assumed to be positive, and transforms the meaning of \code{eqv.level} to mean the \emph{lower} equivalence threshold for the test. Also, \code{eqv.level} is assumed to be a negative value. Taken together, these correspond to Schuirmann's (1987) asymmetric equivalence intervals. If \code{upper==abs(eqv.level)}, then \code{upper} will be ignored.}
 \item{conf.level}{confidence level of the interval, and complement of the test's nominal type I error rate \mjeqn{\alpha}{alpha}.}
 \item{relevance}{reports results and inference for combined tests for difference and for equivalence for a specific \code{conf.level}, \code{eqv.type}, \code{eqv.level}, and, if used, \code{upper}. See the Remarks section more details on inference from combined tests.}
}
\details{\code{tost.regress} tests for the equivalence of each regression coefficient and zero within separate symmetric equivalence intervals defined by \code{eqv.type} and \code{eqv.level} for using a two one-sided \emph{t} tests approach (Schuirmann, 1987). Typically (`positivist') null hypotheses are framed from an assumption of a lack of difference between two quantities, and reject this assumption only with sufficient evidence. When performing tests for equivalence, one frames a (`negativist') null hypothesis with the assumption that two quantities are different by at least as much as an equivalence interval defined by some chosen level of tolerance. \bold{Note:} This version of \code{tost.regress} does not yet implement survey regression, bootstrap or jacknife estimation, or regression with robust or cluster standard errors, and currently implements only the simplest OLS functionality found in the Stata program \code{tostregress}. 

An equivalence null hypothesis takes one of the following two forms depending on whether equivalence is defined in terms of \mjeqn{\Delta}{Delta} (equivalence expressed in the same units as the \code{x} and \code{y} varibales) or in terms of \mjeqn{\epsilon}{epsilon} (equivalence expressed in the units of the \emph{t} distribution with the given degrees of freedom):

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|\beta_{x}| \ge \Delta}{&nbsp;&nbsp;Ho: |b_x| >= Delta},\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{\beta_x - \Delta}{b_x-Delta} to \mjeqn{\beta_x + \Delta}{b_x+Delta.} This translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{ H}_{01}^{-}\text{: }\beta_{x} \ge \Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: b_x >= Delta}, or\cr
\emph{}\mjeqn{\phantom{2222}\text{ H}_{02}^{-}\text{: }\beta_{x} \le -\Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: b_x <= Delta}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|T| \ge \varepsilon ,}{&nbsp;&nbsp;Ho: |T| >= epsilon,}\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{-\varepsilon}{--epsilon} to \mjeqn{\varepsilon}{epsilon}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }T \ge \varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: T >= epsilon}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }T \le -\varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: T <= --epsilon}.

When an asymmetric equivalence interval is defined using the \code{upper} option the general negativist null hypothesis becomes:

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }\beta_{x} \le \Delta_{\text{lower}}}{&nbsp;&nbsp;Ho: b_x <= Delta_lower}, or \mjeqn{\beta_{x} \ge \Delta_{\text{upper}}}{Ho: b_x >= Delta_upper}\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{\left(\beta_{x}\right) + \Delta_{\text{lower}}}{(b_x) + Delta_lower} to \mjeqn{\left(\beta_{x}\right) + \Delta_{\text{upper}}}{(b_x) + Delta_upper}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }\beta_{x} \ge \Delta_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: b_x >= Delta_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }\beta_{x} \le \Delta_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: b_x <= Delta_lower}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }T \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;Ho: T <= epsilon_lower}, or \mjeqn{T \ge \varepsilon_{\text{upper}}}{T >= epsilon_upper}, with:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }T \ge \varepsilon_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: T >= epsilon_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }T \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: T <= epsilon_lower}.\cr
 
NOTE: the appropriate level of \mjeqn{\alpha = (1 - }{alpha = (1 -- }\code{conf.level}\mjeqn{)}{)} is precisely the same as in the corresponding two-sided test for mean difference, so that, for example, if one wishes to make a type I error \%1 of the time, one simply conducts both of the one-sided tests of \mjeqn{\text{H}_{01}^{-}}{Ho1} and \mjeqn{\text{H}_{02}^{-}}{Ho2} by comparing the resulting p-value to 0.01 (Tryon and Lewis, 2008; Wellek, 2010).

\subsection{Remarks}{As described by Tryon and Lewis (2008), when rejection decisions from both tests for difference (e.g., \mjeqn{\text{H}_{0}^{+}\text{: }\beta_{x} = 0}{positivist Ho: b_x = 0} or ) and tests for equivalence (e.g., either \mjeqn{\text{H}_{0}^{-}\text{: }|\beta_{x}| \ge \Delta}{negativist Ho: |b_x| >= Delta}, or \mjeqn{\text{H}_{0}^{-}\text{: }|T| \ge \varepsilon}{negativist Ho: |T| >= epsilon}) are combined, there are four possible interpretations for a given \mjeqn{\alpha}{alpha} and \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}:

\enumerate{
\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but fail to reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{relevant difference} in means at least as large as \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is \bold{equivalence} in means within the equivalence range (i.e. defined by \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}).

\item One may reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{trivial difference} in means which lies within the equivalence range (i.e. defined by \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}).

\item One may fail to reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and draw an \bold{indeterminate} conclusion, because the data are underpowered to detect either difference or equivalence.
}
}
}
\value{
\code{tost.regress} returns:
 \item{N}{the sample size.}
 \item{df_m}{the model degrees of freedom.}
 \item{df_r}{the residual degrees of freedom.}
 \item{F}{the \emph{F} statistic.}
 \item{r2}{\mjeqn{R^2}{R-squared}.}
 \item{rmse}{root mean squared error.}
 \item{mss}{model sum of squares.}
 \item{rss}{residual sum of squares.}
 \item{r2_a}{adjusted \mjeqn{R^2}{R-squared}.}
 \item{alpha}{1 - \code{conf.level}.}
 \item{T1}{vector containing the value of the \mjeqn{t_1}{t\U2081} test statistics.}
 \item{T2}{vector containing the value of the \mjeqn{t_2}{t\U2082} test statistics.}
 \item{T_pos}{if \code{relevance=TRUE} a vector containing the value of the \mjeqn{t}{t} test statistics for the positivist tests for the difference.}
 \item{P1}{vector of \emph{p} values corresponding to the test statistics in \code{T1}.}
 \item{P2}{vector of \emph{p} values corresponding to the test statistics in \code{T2}.}
 \item{P_pos}{if \code{relevance=TRUE} a vector of \emph{p} values corresponding to the test statistics in \code{T_pos}.}
 \item{SE}{vector of estimated standard deviations of the regression coefficients corresponding to \code{B}, also corresponding to the square roots of the diagonal of \code{V}.}
 \item{V}{variance-covariance matrix corresponding to \code{B}.}
 \item{Beta}{vector of standardized regression coefficients corresponding to \code{B}, where the standardized coefficient for the effect of \emph{x} on \emph{y} is \mjeqn{\beta^{*}_{x}=\frac{s_x}{s_y}\beta_{x}}{bx* = (s_x/s_y)*bx}, and \mjeqn{s_x}{s_x} is the sample standard deviation of \emph{x}, \mjeqn{s_y}{s_y} is the sample standard deviation of \emph{y}, and \mjeqn{\beta_{x}}{bx} is the non-standardized coefficient of the effect of \emph{x} on \emph{y}.}
 \item{thresholds_lower}{vector containing the lower equivalence thresholds.}
 \item{thresholds_upper}{vector containing the upper equivalence thresholds.}
 \item{conclusions}{if \code{relevance=TRUE} a vector containing the relevance test conclusion string for a given \mjeqn{\alpha}{\U03B1} and the \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5} for the tests as specified for each coefficient.}
 }
\author{
Alexis Dinno (\email{alexis.dinno@pdx.edu})

Please contact me with any questions, bug reports or suggestions for improvement. Fixing bugs will be facilitated by sending along:
\enumerate{
\item a copy of the data (de-labeled or anonymized is fine),\cr
\item a copy of the command syntax used, and\cr
\item a copy of the exact output of the command.\cr
}
I am endebted to my winter 2013 and fall 2023 students for their inspiration. Much appreciation to Mick McVeety for troubleshooting the translation of my Stata \bold{tost} package to R.
\subsection{Suggested citation}{Dinno, A. 2025. \bold{tost.regress}: Linear regression tests for equivalence. In: \bold{tost.suite} R software package.}
}
\references{

Schuirmann, D. A. (1987) \href{https://pubmed.ncbi.nlm.nih.gov/3450848/}{A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}. \emph{Journal of Pharmacokinetics and Biopharmaceutics}. \bold{15}, 657--680.

Tryon, W. W., and C. Lewis. (2008) \href{https://pubmed.ncbi.nlm.nih.gov/18778155/}{An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}. \emph{Psychological Methods}. \bold{13}, 272--277

Wellek, S (2010) \href{https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184}{\emph{Testing Statistical Hypotheses of Equivalence and Noninferiority}}, second edition. Chapman and Hall/CRC Press. p. 31.
}
\seealso{
  \code{\link{lm}}.
}
\examples{
require("webuse")

# Setup
webuse("auto")

# Report equivalence tests for a linear regression; equivalence interval is
# +/- 1 sd beyond the critical value of T for alpha = 0.05 and df = 71, and
# where sd = sqrt(df/(df-2)).
tost.regress(
  auto$mpg ~ auto$weight + auto$foreign, 
  eqv.type="epsilon", 
  eqv.level=qt(.95, df=71)+1*sqrt(71/(71-2)), 
  conf.level=0.95,
  relevance=FALSE)


# Report relevance tests for a linear regression; equivalence interval is
# +/- 1 sd beyond the critical value of T for alpha = 0.05 and df = 71.
tost.regress(
  auto$mpg ~ auto$weight + auto$foreign, 
  eqv.type="epsilon", 
  eqv.level=qt(.95, df=71)+1*sqrt(71/(71-2)), 
  conf.level=0.95,
  relevance=TRUE)

# Setup
webuse("auto")
auto["gp100m"] <- 100/auto$mpg

# Fit a better linear regression, from a physics standpoint, but add
# asymmetric intervals, and report relevance test results.  The lower end of
# the equivalence interval = qt(.95, 71)+1.5*sqrt(71/(71-2)) = 3.188184 meaning 
# eequivalence must lay no more than 1.5 sd beyond the critical value of T for 
# alpha = 0.05 and df = 71.  The upper end of the equivalence interval = 
# qt(.95, 71)+1*sqrt(71/(71-2)) = 2.680989 meaning equivalence must lay no more 
# than 1 sd beyond the critical value of T for alpha = 0.05 and df = 71, and 
# where sd = sqrt(df/(df-2)).gp100m <- 100/auto$mpg
tost.regress(
  auto$gp100m ~ auto$weight + auto$foreign, 
  eqv.type="epsilon", 
  eqv.level=qt(.95, df=71)+1.5*sqrt(71/(71-2)), 
  upper=qt(.95, df=71)+1*sqrt(71/(71-2)), 
  conf.level=0.95,
  relevance=TRUE)

# Obtain standardized regression coefficients from the above model
tost.regress(
  auto$gp100m ~ auto$weight + auto$foreign, 
  eqv.type="epsilon", 
  eqv.level=qt(.95, df=71)+1.5*sqrt(71/(71-2)), 
  upper=qt(.95, df=71)+1*sqrt(71/(71-2)), 
  conf.level=0.95,
  relevance=TRUE)$Beta

# Report equivalence tests when suppressing the intercept term
tost.regress(
  auto$weight ~ 0 + auto$length, 
  eqv.type="delta", 
  eqv.level=5, 
  conf.level=0.95,
  relevance=FALSE)
  
# Report equivalence tests when the model already has constant; express
# equivalence interval in units of the variable only for length, and in units
# of the test statistic for each level of foreign. For the latter, the
# equivalence interval is +/- 1 sd beyond the critical value of T for
# alpha = 0.05.
tost.regress(
  auto$weight ~ 0 + auto$length + as.factor(auto$foreign), 
  eqv.type=c("delta", "epsilon", "epsilon"), 
  eqv.level=c(5, qt(.95, 71)+1*sqrt(71/(71-2)), qt(.95, 71)+1*sqrt(71/(71-2))), 
  conf.level=0.95,
  relevance=FALSE)


  }
\keyword{htest}
\keyword{stats}
