% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_runtoxdrc.R
\name{toxdrc_normalization}
\alias{toxdrc_normalization}
\title{Set normalization configuration for the runtoxdrc pipeline.}
\usage{
toxdrc_normalization(
  blank.correction = FALSE,
  blank.label = "Blank",
  normalize.resp = FALSE,
  relative.label = 0
)
}
\arguments{
\item{blank.correction}{Logical. Indicates if the response variable
should be blank corrected. Defaults to FALSE.}

\item{blank.label}{Character. Label used for the blank level.
Defaults to "Blank".}

\item{normalize.resp}{Logical. Indicates if response variable should
be normalized to a given group. Defaults to FALSE.}

\item{relative.label}{Label used for the group values will be
normalized to. Defaults to 0.}
}
\value{
A named list containing normalization configuration for use in
 [runtoxdrc()].
}
\description{
Control blank correction and normalization of the response variable.
}
\examples{
toxdrc_normalization(blank.correction = TRUE, relative.label = "Control")

}
\seealso{
[config_runtoxdrc], [runtoxdrc()], [blankcorrect()], [normalizeresponse()]
}
