% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_scheme.R
\docType{class}
\name{DiffusionScheme-class}
\alias{DiffusionScheme-class}
\alias{DiffusionScheme}
\title{The DiffusionScheme class}
\description{
This class represents a diffusion MRI acquisition scheme. It encapsulates a
series of diffusion-weighted volume acquisitions, each with an associated
diffusion-sensitising gradient direction, in one or more "shells" with a
given weighting ("b-value").
}
\section{Fields}{

\describe{
\item{\code{bValues}}{A vector of b-values in seconds per square millimetre, one
per volume acquired.}

\item{\code{gradientDirections}}{A matrix of gradient directions, one row per
volume acquired. Columns give the x, y and z components of the directions,
relative to the image axes.}

\item{\code{shellIndices}}{An integer vector giving the shell index associated with
each volume. This is calculated internally and coded such that every
volume with a b-value below \code{unweightedThreshold} gets an index of 0,
and then others are grouped into shells with b-values differing by less
than the relative \code{tolerance} specified (2% by default). This
grouping is indicative only, and not stored in direction files.}

\item{\code{shellValues}}{A vector of b-values associated with each shell. These
are calculated as the mode of the assigned volume b-values in each case.}
}}

\section{Methods}{

\describe{
\item{\code{summarise()}}{Summarise key aspects of the object}
}}

