% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainR.R
\name{GetServiceDetailsRequest}
\alias{GetServiceDetailsRequest}
\title{Get service details}
\usage{
GetServiceDetailsRequest(
  serviceID,
  token = get_token(),
  url = "https://lite.realtime.nationalrail.co.uk/OpenLDBWS/ldb11.asmx",
  verbose = FALSE
)
}
\arguments{
\item{serviceID}{(string): The LDBWS service ID of the service to request
the details of. The service ID is obtained from a service listed in a
\code{StationBoard} object returned from any other request.}

\item{token}{Token to access the data feed. The token can be obtained at
\url{http://realtime.nationalrail.co.uk/OpenLDBWSRegistration/}.}

\item{url}{Data feed source URL.}

\item{verbose}{Boolean flag to indicate whether or not to show status
messages.}
}
\value{
Tibble with departure records.
}
\description{
Get the service details for a specific service identified by a station board.
These details are supplied relative to the station board from which the
\code{serviceID} field value was generated. Service details are only
available while the service appears on the station board from which it was
obtained. This is normally for two minutes after it is expected to have
departed, or after a terminal arrival. If a request is made for a service
that is no longer available then a \code{NULL} value is returned.
}
