% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{trajeR}
\alias{trajeR}
\title{Fitting longitudinal mixture models}
\usage{
trajeR(
  Y,
  A,
  Risk = NULL,
  TCOV = NULL,
  degre = NULL,
  degre.nu = 0,
  degre.phi = 0,
  Model,
  Method = "L",
  ssigma = FALSE,
  ymax = max(Y, na.rm = TRUE) + 1,
  ymin = min(Y, na.rm = TRUE) - 1,
  hessian = TRUE,
  itermax = 100,
  paraminit = NULL,
  ProbIRLS = TRUE,
  refgr = 1,
  fct = NULL,
  diffct = NULL,
  nbvar = NULL,
  ng.nl = NULL,
  nls.lmiter = 50
)
}
\arguments{
\item{Y}{Matrix. A matrix containing the variables in the model.}

\item{A}{Matrix. A matrix containing the time variable data.}

\item{Risk}{Matrix. An optional matrix that modify the probability of belong to group. By default its value is a matrix
with one column  with value 1.}

\item{TCOV}{Matrix. An optional matrix containing the time covariate that influence the trajectory themselves.
By default its value is NULL.}

\item{degre}{Vector of integer. The degree of every polynomial function.}

\item{degre.nu}{Vector of integer. The degree of all Poisson part for a ZIP model.}

\item{degre.phi}{Vector of integer. The degree of  beta parameter for  a BETA model.}

\item{Model}{String. The model used. The value are LOGIT for a Logit Mixture model,
CNORM for a Censored Normal Mixture Model or ZIP for Zero Inflated Poisson Mixture model.}

\item{Method}{String. Determine the method used for find the parameters of the model.
The value are L for the Maximum Likelihood Estimation, EM for Expectation Maximization method
with quasi newton method inside, EMIWRLS for Expectation Maximization method with Iterative
Weighted Least Square.}

\item{ssigma}{Logical. By default its value is FALSE. For the CNORM model,
indicate if we want the same sigma for all normal density function.}

\item{ymax}{Real. For the CNORM model, indicate the maximum value of the data. It concern only the model
with censored data. By default its value is the maximum value of the data plus 1.}

\item{ymin}{Real. For the CNORM model, indicate the minimum value of the data. It concern only the model
with censored data. By default its value is the maximum value of the data minus 1.}

\item{hessian}{Logical. Indicate if we want calculate the hessian matrix. Default is FALSE.
If the method use is Likelihood, the hessian is calculated by inverting the Information's Fisher Matrix.
To avoid numerically singular matrix we find the pseudo inverse matrix by using the \code{ginv} function int he package MASS.
If the method is EM or EMIWRLS, the hessian is calculated by using Louis method.}

\item{itermax}{Integer. Indicate the maximal number of iteration for \code{optim} function or for the EM algorithm.}

\item{paraminit}{Vector. The vector of initial parameters. By default \code{trajeR} calculate the initial value
based of the range or the standard deviation.}

\item{ProbIRLS}{Logical. Indicate the method to sue in the search of predictor's probability. If TRUE (by default) we use
IRLS method and if FALSE we use optimization method.}

\item{refgr}{Integer. The number of reference group. By default is 1.}

\item{fct}{Function. The definition of the function  f in the definition in nonlinear model.}

\item{diffct}{Function. The differential of the function f in the nonlinear model.}

\item{nbvar}{Integer. The number of variable in the nonlinear model.}

\item{ng.nl}{Integer. The number of group for a non linear model.}

\item{nls.lmiter}{Integer. In the case of non linear model, the maximum number of iterations allowed.}
}
\value{
return an object of class "\code{Trajectory.LOGIT}".
The generic accessor functions \code{beta}, \code{delta}, \code{theta}, \code{sd}, \code{tab}, \code{Likelihood},
\code{ng}, \code{model} and \code{method} extract various useful features of the value returned by \code{trajeR}.

An object of class "\code{Trajectory.LOGIT}" is a list containing at least the following components:

\describe{
\item{\code{beta}}{a vector of the parameters beta.}
\item{\code{delta}}{a vector of the parameter delta. Only if we use time covariate.}
\item{\code{theta}}{a vector with the parameter theta if there exist a covariate X that modify
  the probability or the probability of group membership.}
\item{\code{sd}}{a vector of the standard deviation of the parameters.}
\item{\code{tab}}{a matrix with all the parameters and standard deviation.}
\item{\code{Likelihood}}{a real with the Likelihood obtained by the parameters.}
\item{\code{ng}}{a integer with the number of group.}
\item{\code{model}}{a string with the model used.}
\item{\code{method}}{a string with the method used.}
}
}
\description{
\code{trajeR} is used to fit longitudinal mixture models. It used 3 types of mixture models : LOGIT, ZIP and censored Normal.
}
\details{
Models for trajeR is, by default, a polynomial regression of the time value parameters for each groups. The number fo group is controlled by the integer \code{ng}.
We can specify the degre of the polynomial shape for each groups by the vector \code{degre}.
}
\examples{
\donttest{
data("dataNORM01")
solL <- trajeR(dataNORM01[, 1:5], dataNORM01[, 6:10],
  ng = 3, degre = c(2, 2, 2),
  Model = "CNORM", Method = "L", ssigma = FALSE,
  hessian = TRUE
)
}
}
