% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3D.R
\name{Traj3DFromCoords}
\alias{Traj3DFromCoords}
\title{Create a 3D Trajectory Object}
\usage{
Traj3DFromCoords(
  track,
  xCol = 1,
  yCol = 2,
  zCol = 3,
  timeCol = NULL,
  fps = 50,
  spatialUnits = "m",
  timeUnits = "s"
)
}
\arguments{
\item{track}{data frame containing cartesian coordinates and optionally times
for the points in the trajectory.}

\item{xCol}{Name or index of the \code{x} column in \code{track} (default 1).}

\item{yCol}{Name or index of the \code{y} column in \code{track} (default 2).}

\item{zCol}{Name or index of the \code{z} column in \code{track} (default 3).}

\item{timeCol}{optional name or index of the column which contains coordinate
times.}

\item{fps}{Frames per second - used to calculate relative coordinate times if
\code{track} does not contain a \code{time} column. Time intervals between
coordinate are assumed to be constant throught the entire track.}

\item{spatialUnits}{Abbreviation for the x, y and z units.}

\item{timeUnits}{Abbreviation for the units that time is recorded in.}
}
\value{
An object with class "\code{Trajectory3D}", which is a data.frame
  with the following components: \item{x}{X coordinates of trajectory
  points.} \item{y}{Y coordinates of trajectory points.} \item{time}{Time (in
  \code{timeUnits}) for each point. if \code{timeCol} is specified, values
  are \code{track[,timeCol]}, otherwise values are calculated from
  \code{fps}.} \item{displacementTime}{Relative frame/observation times, with
  frame/observation 1 at time \code{0}.} \item{polar}{X and y coordinates
  represented as complex numbers, to simplify working with 2D segment angles.
  Note that the z dimension is not represented.}
  \item{displacement}{2-dimensional displacement vectors (represented as
  complex numbers) between each pair of consecutive points. Note that the z
  dimension is not represented.}
}
\description{
\code{Traj3DFromCoords} creates a new 3-dimensional trajectory object from a
set of 3-dimensional cartesian coordinates, times and some metadata. A 3D
trajectory is a 2D trajectory (see \code{\link{TrajFromCoords}}) with the
addition of a \code{z} coordinate. \code{trajr} functions that expect a 2D
trajectory will work on a 3D trajectory by simply ignoring the \code{z}
dimension, so should only be used with care. A small number of functions
operate on 3D trajectories, and are prefixed by \code{Traj3D}. Existing
\code{trajr} functions that that do not deal with spatial data (e.g.
\code{\link{TrajDuration}}, \code{\link{TrajGetNCoords}} etc.) can safely be
used.
}
\details{
The coordinates are sometimes referred to as "relocations". Rows containing
\code{NA} coordinate or time values at the start or end of the trajectory are
discarded. \code{NA} coordinates or times in the middle of the trajectory
generate an error.

If \code{timeCol} is specified, \code{track[,timeCol]} is expected to contain
the time (in some numeric units) of each coordinate. Otherwise, times are
calculated for each point as \code{(coord - 1) / fps} where \code{coord} is
the index of the point; in other words, sampling at constant time intervals
is assumed. Time values require conversion if they are not numeric. It may be
possible to use `strptime` for this purpose, or \code{\link{TrajConvertTime}}
can be used to convert multiple field time values.

\code{x} and \code{y} must be square units. Longitude and latitude are not
suitable for use as \code{x} and \code{y} values, since in general, \code{1°
lat != 1° lon}. To create a trajectory from positions in latitude and
longitude, it is first necessary to transform the positions to a suitable
spatial projection such as UTM (possibly by using \code{spTransform} from the
\code{rgdal} package).

Leading and trailing rows with \code{NA} coordinate values are discarded.
\code{NA} coordinate values within a trajectory generate an error.
}
\seealso{
\code{\link{Traj3DLength}}, \code{\link{Traj3DStepLengths}},
  \code{\link{Traj3DDistance}}, \code{\link{Traj3DStraightness}},
  \code{\link{Traj3DSmoothSG}}, \code{\link{Traj3DResampleTime}},
  \code{\link{Traj3DRediscretize}}, \code{\link{TrajFromCoords}} for creating
  2-dimensional trajectories
}
