% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_findingemo.R
\name{download_findingemo_data}
\alias{download_findingemo_data}
\title{Download FindingEmo-Light Dataset}
\usage{
download_findingemo_data(
  target_dir,
  max_images = NULL,
  randomize = FALSE,
  skip_existing = TRUE,
  force = FALSE
)
}
\arguments{
\item{target_dir}{Character. Directory to download the dataset to.}

\item{max_images}{Integer. Maximum number of images to download (optional).}

\item{randomize}{Logical. If TRUE and max_images is specified, randomly 
select images for download. Useful for creating test/benchmark subsets 
(default: FALSE).}

\item{skip_existing}{Logical. Whether to skip download if dataset already 
exists (default: TRUE).}

\item{force}{Logical. Force download even if dataset exists (default: FALSE).}
}
\value{
A list containing:
\itemize{
  \item \code{success}: Logical indicating if download was successful
  \item \code{message}: Character string with status message
  \item \code{target_dir}: Path to downloaded data
  \item \code{annotation_file}: Path to annotation file (if successful)
  \item \code{urls_file}: Path to URLs file (if successful)
  \item \code{image_count}: Number of images downloaded (if any)
  \item \code{annotations}: Full annotations data.frame (raw)
  \item \code{evaluation_data}: Data.frame filtered to downloaded images
        with columns suitable for evaluation workflows (id, truth, image_file,
        image_path, valence, arousal, emo8_label, emotion)
  \item \code{evaluation_csv}: Path to saved CSV of evaluation_data
  \item \code{matched_count}: Number of annotations matched to downloaded images
}
}
\description{
Downloads the FindingEmo-Light dataset using the official PyPI package.
This dataset contains 25k images with emotion annotations including valence,
arousal, and discrete emotion labels, focusing on complex naturalistic scenes
with multiple people in social settings.
}
\details{
This function requires the \code{findingemo-light} Python package to be 
installed. Use \code{setup_modules()} to install required dependencies
before calling this function.

The FindingEmo dataset is described in:
Mertens, L. et al. (2024). "FindingEmo: An Image Dataset for Emotion 
Recognition in the Wild". NeurIPS 2024 Datasets and Benchmarks Track.

The dataset uses a flat directory structure with all images stored directly 
in the images/ subdirectory, annotations.csv and urls.json at the root level.

**Note**: For copyright reasons, the dataset provides URLs and annotations
only. Images are downloaded on-demand from their original sources.
}
\examples{
\dontrun{
# First install required modules
setup_modules()

# Download dataset to local directory
result <- download_findingemo_data("./findingemo_data")

if (result$success) {
  cat("Dataset downloaded to:", result$target_dir)
  cat("Images downloaded:", result$image_count)
}

# Download random subset for testing/benchmarking
result <- download_findingemo_data(
  target_dir = "./findingemo_test",
  max_images = 100,
  randomize = TRUE
)

# Download subset with flat directory structure (always used)
result <- download_findingemo_data(
  target_dir = "./findingemo_subset",
  max_images = 50
)

# Force re-download
result <- download_findingemo_data(
  target_dir = "./findingemo_data",
  force = TRUE
)
}

}
\seealso{
\code{\link{load_findingemo_annotations}}, \code{\link{setup_modules}}
}
