% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat.R
\name{flat_serialize}
\alias{flat_serialize}
\alias{flat_deserialize}
\alias{flat_tag}
\alias{flat_format}
\alias{flat_example}
\title{Serialize Objects to Flat Strings}
\usage{
flat_serialize(x = list(), tag_sep = ": ", tag_empty = "")

flat_deserialize(string = "", tag_sep = ": ")

flat_tag(x = list(), tag_sep = ": ", tag_empty = "")

flat_format(x = list())

flat_example()
}
\arguments{
\item{x}{A list. It can be empty.}

\item{tag_sep}{A non-empty and non-NA character string. The separator to use
when creating tags from names (recursively) extracted from \code{x}.}

\item{tag_empty}{A non-NA character string. The value to use as a substitute
for empty names. Positional indices are automatically appended to it to
ensure tags are always unique.}

\item{string}{A non-NA character string. It can be empty. Contents to
deserialize.}
}
\value{
\code{\link[=flat_serialize]{flat_serialize()}} returns a character string, possibly empty.

\code{\link[=flat_deserialize]{flat_deserialize()}} returns a named list, possibly empty. Its structure
depends on the underlying tags.

\code{\link[=flat_tag]{flat_tag()}} returns a character vector, possibly empty.

\code{\link[=flat_format]{flat_format()}} returns an unnamed list having the same \emph{shape} as \code{x}. See
Details.

\code{\link[=flat_example]{flat_example()}} returns a character string (a serialized example),
invisibly. It is used for its side-effect of printing an illustration of
the format (with useful information).
}
\description{
Serialize \R objects into textual sequences of unindented (\emph{flat}) and
identifiable sections. These are called FLAT (1.0) objects.
}
\details{
The Flat format (\strong{F}lat \strong{L}ist \strong{A}s \strong{T}ext, or FLAT) is a minimal
textual data serialization format optimized for \R \code{\link{list}} objects.
Elements are converted to character strings and organized into unindented
sections identified by a tag. Call \code{\link[=flat_example]{flat_example()}} for a valid example.

\code{\link[=flat_serialize]{flat_serialize()}} serializes \code{x} into a FLAT object.

\code{\link[=flat_deserialize]{flat_deserialize()}} is the inverse operation: it converts a FLAT object
back into a list. The latter has the same shape as the original one, but
\itemize{
\item \link{atomic} vectors are not reconstituted (they are deserialized as
elements of length 1), and
\item all elements are also left as character strings.
}

The convention is to serialize an empty list to an empty character string.
\subsection{Internal mechanisms}{

\code{\link[=flat_tag]{flat_tag()}} and \code{\link[=flat_format]{flat_format()}} are called internally by \code{\link[=flat_serialize]{flat_serialize()}}.
Aside from debugging purposes, they should not be called outside of the
former.

\code{\link[=flat_tag]{flat_tag()}} creates tags from names extracted from \code{x} and formats them.
Tags may not be unique, depending on \code{x}'s structure and names.

\code{\link[=flat_format]{flat_format()}} recursively formats the elements of \code{x} as part of the
serialization process. It
\itemize{
\item converts \code{NULL} to the \code{"NULL"} character string,
\item converts other elements to character strings using \code{\link[=format]{format()}} and
\item replaces empty lists by a \verb{<empty list>} constant treated as a
placeholder.
}
}
}
\keyword{internal}
