% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transPlot.R
\name{transPlot}
\alias{transPlot}
\title{Plots transport profiles of single run experiments}
\usage{
transPlot(trans, trend = NULL, secondary = NULL, tertiary = NULL,
  sec.trend = "spline", lin.secon = FALSE, span = 0.75, legend = FALSE,
  xlab = "Time (h)", ylab = expression(Phi), xlim = NULL, ylim = NULL,
  xbreaks = NULL, ybreaks = NULL, size = 2.8, bw = FALSE, srs = NULL,
  plot = TRUE)
}
\arguments{
\item{trans}{Data frame with the complete transport information of
interest species. Must be generated using
\code{\link{conc2frac}}. This is the only non-optional
parameter.}

\item{trend}{Non-linear regression model of the main transport profile
generated using \code{\link{transTrend}}.}

\item{secondary}{Secondary species transport data frame (see
\code{\link{conc2frac}}).}

\item{tertiary}{Tertiaty species transport data frame (see
\code{\link{conc2frac}}).}

\item{sec.trend}{Type of trend line to be used for secondary and tertiary
species data. Default is \code{'spline'} but
\code{'linear'}, \code{'loess'} and \code{'logarithmic'}
are also allowed.}

\item{lin.secon}{Deprecated. Use \code{sec.trend = 'linear'} instead.}

\item{span}{Amount of smoothing when \code{sec.tred = 'loess'}. Is a
value between 0 and 1. Default is 0.75}

\item{legend}{Logical. If \code{FALSE}, the default, the legend is not
included.}

\item{xlab}{Label to be used for x axis. Text and expression allowed.}

\item{ylab}{Label to be used for y axis. Text and expression allowed.}

\item{xlim}{Numeric vector of limits for X-axis.}

\item{ylim}{Numeric vector of limits for X-axis.}

\item{xbreaks}{Numeric vector of x-axis breaks.}

\item{ybreaks}{Numeric vector of x-axis breaks.}

\item{size}{Size used for points in the plot.}

\item{bw}{Logical, if \code{FALSE}, the default, a color version of
the plot is given. If a black and white version is
required, it must be set to \code{TRUE}.}

\item{srs}{Deprecated.}

\item{plot}{Logical. If \code{TRUE}, the default, the plot is printed
in the current graphical device.}
}
\value{
Plot of the transport profile considering all provided species.
}
\description{
Given the transport complete information of the interest species and,
optionally, secondary and tertiary species, the function plots transport
profiles including (if given) non-linear regression models that can be
obtained using \code{\link{transTrend}}.
}
\details{
Most \code{transmem} graphical representations are made using the package
\code{ggplot2} so the function returns a ggplot2 object that can be
assigned to a variable for further modification.

This function has a version that uses replicated experiments and
may be useful to illustrate repeateability. For more information see
\code{\link{transPlotWR}}.
}
\examples{
  data(seawaterLiNaK)
  trend <- transTrend(trans = seawaterLiNaK$Lithium.1, model = 'paredes')
  transPlot(trans = seawaterLiNaK$Lithium.1, trend = trend,
            secondary = seawaterLiNaK$Sodium.1,
            tertiary = seawaterLiNaK$Potassium.1)
  transPlot(trans = seawaterLiNaK$Lithium.1, trend = trend,
            secondary = seawaterLiNaK$Sodium.1,
            tertiary = seawaterLiNaK$Potassium.1, bw = TRUE)
}
\references{
Wickham H (2016). ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York. ISBN 978-3-319-24277-4,
\url{https://ggplot2.tidyverse.org}.
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Eduardo Rodriguez de San Miguel, \email{erdsmg@unam.mx}
}
