% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epts.R
\name{epts}
\alias{epts}
\title{Estimated Post-Transplant Survival Score (EPTS)}
\usage{
epts(age, dm, prev_tx, dx)
}
\arguments{
\item{age}{numeric vector of patient age in years (with decimals)}

\item{dm}{numeric vector of whether patient diabetic (1 = yes, 0 = no)}

\item{prev_tx}{numeric vector of whether patient has a previous solid organ transplant}

\item{dx}{numeric vector of duration of dialysis in years (with decimals)}
}
\value{
numeric vector of EPTS scores as percentiles
}
\description{
A vectorised function to calculate EPTS scores as percentiles for norm-related prediction of
patient survival after adult renal transplants. This function generates the EPTN scores
as percentiles using the most recent lookup table on the OPTN
website published in March 2019 and using SRTR data from 2018. The table can be found
at https://optn.transplant.hrsa.gov/media/2973/epts_mapping_table_2018.pdf
}
\details{
This function requires the dplyr package to be installed.
References: https://optn.transplant.hrsa.gov/resources/allocation-calculators/epts-calculator/ and
https://optn.transplant.hrsa.gov/media/1511/guide_to_calculating_interpreting_epts.pdf
}
\examples{
epts(age = 23.5838467, dm = 0, prev_tx = 1, dx = 5.0814511)
epts(age = 52.8788501, dm = 0, prev_tx = 0, dx = 0)
epts(age = 22.5242984, dm = 1, prev_tx = 1, dx = 6.8747433)
}
