% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treats.R
\name{treats}
\alias{treats}
\title{Diversity and disparity simulator}
\usage{
treats(
  stop.rule,
  bd.params,
  traits = NULL,
  modifiers = NULL,
  events = NULL,
  save.steps = NULL,
  null.error = FALSE,
  replicates,
  verbose = TRUE
)
}
\arguments{
\item{stop.rule}{The rules on when to stop the simulation (see details).}

\item{bd.params}{A \code{"bd.params"} object or a named list of parameters for the birth-death process (see details or \code{\link{make.bd.params}}).}

\item{traits}{A \code{"traits"} object (see \code{\link{make.traits}}).}

\item{modifiers}{A \code{"modifiers"} object (see \code{\link{make.modifiers}}).}

\item{events}{A \code{"events"} object (see \code{\link{make.events}}).}

\item{save.steps}{Optional, \code{"numeric"} value to save the simulations at specific internal points (this can slow down the algorithm significantly for large trees).}

\item{null.error}{Logical, whether to return an error when the birth-death parameters fails to build a tree (\code{FALSE}; default and highly recommended) or whether to return \code{NULL} (\code{TRUE}). Can also be set to an integer value for the numbers of trials (see details).}

\item{replicates}{Optional, the number of replicates for the simulation.}

\item{verbose}{Logical, whether to be verbose (\code{TRUE}; default) or not (\code{FALSE}).}
}
\value{
This function outputs either a \code{"phylo"} object if no traits where generated or a \code{treats} object that is a list of at least two elements: \code{$tree}, a \code{"phylo"} object and \code{$data}, a \code{"matrix"} of the trait values.
}
\description{
Simulating phylogenetic trees and traits. See full manual here: https://github.com/TGuillerme/treats
}
\details{
\code{stop.rule}: The rule(s) for when to stop the simulation. When multiple rules are given, the simulation stops when any rule is broken. The allowed rules are:
\itemize{
  \item \code{max.taxa}   The maximum number of taxa (including extinct ones).
  \item \code{max.living} The maximum number of living taxa (i.e. non extinct).
  \item \code{max.time}   The maximum amount of phylogenetic (in arbitrary units).
}

\code{bd.params}: This can be either a \code{"treats"} \code{"bd.params"} object (see \code{\link{make.bd.params}}) or a list of named parameters. The allowed parameters are:
\itemize{
  \item \code{speciation} The speciation parameter value.
  \item \code{extinction} The extinction parameter value.
}
By default, this parameter is set to \code{bd.params = list(speciation = 1)}

If \code{null.error} is set to a numeric value, the function will run multiple times until a correct tree is generated. Using this option can greatly increase computational time!
}
\examples{
## Setting pure birth tree (no extinction) parameters
my_bd_params <- list(speciation = 1)
## Setting a stopping rule: stop when reaching 10 taxa.
my_stop_rule <- list(max.taxa = 10) 

## Run a birth tree without traits
a_tree <- treats(bd.params = my_bd_params,
               stop.rule = my_stop_rule)
## Plot the results
plot(a_tree)

## Add an extinction parameter
my_bd_params$extinction <- 1/3

## Add a simple trait simulation (default Brownian motion)
my_trait <- make.traits()

## Run a birth-death tree with traits simulation
treats(bd.params = my_bd_params,
     stop.rule = my_stop_rule,
     traits    = my_trait)

## Simulating a tree using modifiers
## Making a modifier to make speciation trait dependent
my_modifiers <- make.modifiers(branch.length = branch.length.trait,
                               selection     = selection,
                               speciation    = speciation.trait)

## Simulating the tree
treats(stop.rule = list(max.taxa = 20),
     traits = make.traits(),
     modifiers = my_modifiers)

## Run a birth death tree with an event
## 80\% mass extinction at time 4
mass_extinction <- make.events(
                      target       = "taxa",
                      condition    = age.condition(4),
                      modification = random.extinction(0.8))

## Set the simulation parameters
stop.rule <- list(max.time = 5)
bd.params <- list(extinction = 0, speciation = 1)

## Run the simulations
set.seed(123)
results <- treats(bd.params = bd.params,
                stop.rule = stop.rule,
                events    = mass_extinction)
## Plot the results
plot(results, show.tip.label = FALSE)
axisPhylo()


}
\seealso{
\code{\link{plot.treats}} \code{\link{make.traits}} \code{\link{make.modifiers}} \code{\link{make.events}}
}
\author{
Thomas Guillerme
}
