% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B2I.R
\name{B2I}
\alias{B2I}
\title{Calculation of the B2 index for rooted trees}
\usage{
B2I(tree, logbase = 2)
}
\arguments{
\item{tree}{A rooted tree in phylo format.}

\item{logbase}{The base that shall be used for the logarithm. For binary
trees it is common to use base 2.}
}
\value{
\code{B2I} returns the B2 index of the given tree.
}
\description{
This function calculates the B2 index \eqn{B2(T)} for a given rooted
tree \eqn{T}. The tree must not necessarily be binary. \eqn{B2(T)} is defined as
\deqn{B2(T)=-\sum_{x\in V_L(T)} p_x\cdot log(p_x)}{
B2(T)=-\sum_{x in V_L(T)} p_x * log(p_x)} in which \eqn{V_L(T)} denotes the leaf
set of \eqn{T}, and in which \deqn{p_x=\prod_{v\in anc(x)} \frac{1}{|child(v)|}}{
p_x= \prod_{v in anc(x)} 1/|child(v)|} denotes
the probability of reaching leaf \eqn{x} when starting at the root and assuming
equiprobable branching at each vertex \eqn{v\in anc(x)}{v in anc(x)} with \eqn{anc(x)}
denoting the set of ancestors of \eqn{x} excluding
\eqn{x}. \eqn{child(v)} denotes the set of children of the inner vertex \eqn{v}.\cr
The \eqn{B2} index is a balance index.\cr\cr
For \eqn{n=1} the function returns \eqn{B2(T)=0} and a warning. \cr\cr
For details on the B2 index, see 
also Chapter 11 in "Tree balance indices: a comprehensive survey" (https://doi.org/10.1007/978-3-031-39800-1_11).
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
B2I(tree)

}
\references{
K.-T. Shao and R. R. Sokal. Tree Balance. Systematic Zoology, 39(3):266, 1990. \cr doi: 10.2307/2992186.

P.-M. Agapow and A. Purvis. Power of Eight Tree Shape Statistics to Detect Nonrandom Diversification: A Comparison by Simulation of Two Models of Cladogenesis. Systematic Biology, 51(6):866-872, 2002.doi: 10.1080/10635150290102564. \cr URL https://doi.org/10.1080/10635150290102564.

M. Hayati, B. Shadgar, and L. Chindelevitch. A new resolution function to evaluate tree shape statistics. PLOS ONE, 14(11):e0224197, 2019. doi: 10.1371/journal.pone.0224197.\cr URL https://doi.org/10.1371/journal.pone.0224197.

M. Kirkpatrick and M. Slatkin. Searching for evolutionary patterns in the shape of a phylogenetic tree. Evolution, 47(4):1171-1181, 1993. doi: 10.1111/j.1558-5646.1993.tb02144.x.
}
\author{
Sophie Kersting, Luise Kuehn
}
