% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collessI.R
\name{collessI}
\alias{collessI}
\title{Calculation of the Colless index for rooted binary trees}
\usage{
collessI(tree, method = "original")
}
\arguments{
\item{tree}{A rooted binary tree in phylo format.}

\item{method}{A character string specifying the version that shall be computed.
It can be one of the following: "original", "corrected", "quadratic".}
}
\value{
\code{collessI} returns the Colless index of the given tree according to the chosen method.
}
\description{
This function calculates variants of the Colless index for a given rooted
binary tree \eqn{T}. All of them are imbalance indices.\cr\cr
The original Colless index \eqn{C(T)} is defined as
\deqn{C(T)=\sum_{u \in V_{in}(T)} |n_{u_a}-n_{u_b}|}{
C(T)=\sum_{u in V_in(T)} |n_{u_a}-n_{u_b}|}
in which \eqn{V_{in}(T)}{V_in(T)} denotes the set of all inner vertices
of \eqn{T}, and in which \eqn{n_{u_a}}
and \eqn{n_{u_b}} denote the number of leaves in the two pending subtrees that are
rooted at the direct descendants of \eqn{u}. \cr\cr
The corrected Colless index \eqn{I_C(T)} of \eqn{T} is defined as \eqn{I_C(T)=0} for
\eqn{n=1} and \eqn{n=2} and for \eqn{n>2} as
\deqn{I_C(T)=\frac{2\cdot C(T)}{(n-1)\cdot(n-2)}}{
I_C(T)=2*
C(T)/((n-1)*(n-2))}
in which \eqn{n} denotes the
total number of leaves in \eqn{T}. \cr\cr
The quadratic Colless index \eqn{QC(T)} of \eqn{T} is defined as
\deqn{QC(T)=\sum_{u\in V_{in}(T)} |n_{u_a}-n_{u_b}|^2}{
QC(T)=\sum_{u in V_in(T)} |n_{u_a}-n_{u_b}|^2} \cr\cr
Special cases: For \eqn{n=1} the function returns \eqn{C(T)=I_C(T)=QC(T)=0} and a warning. \cr\cr
For details on the original, corrected and quadratic Colless indices, see 
also Chapters 12, 13 and 15 in "Tree balance indices: a comprehensive survey" 
(https://doi.org/10.1007/978-3-031-39800-1_12, https://doi.org/10.1007/978-3-031-39800-1_13, 
https://doi.org/10.1007/978-3-031-39800-1_15).
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
collessI(tree, method="original")
collessI(tree, method="corrected")
collessI(tree, method="quadratic")

}
\references{
D. Colless. Review of Phylogenetics: the theory and practice of phylogenetic systematics. Systematic Zoology, 1982. ISSN 00397989.

T. M. Coronado, M. Fischer, L. Herbst, F. Rossello, and K. Wicke. On the minimum value of the Colless index and the bifurcating trees that achieve it. Journal of Mathematical Biology, 2020.doi: 10.1007/s00285-020-01488-9.

S. B. Heard. Patterns in tree balance among cladistic, phenetic, and randomly generated phylogenetic trees. Evolution, 1992. doi: 10.1111/j.1558-5646.1992.tb01171.x.

K. Bartoszek, T. M. Coronado, A. Mir, and F. Rossello. Squaring within the Colless index yields a better balance index. Mathematical Biosciences, 331:108503, 2021. doi: 10.1016/j.mbs.2020.108503.
}
\author{
Luise Kuehn and Sophie Kersting
}
