% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_delete.R
\name{trem_delete}
\alias{trem_delete}
\title{Perform a DELETE request to Tremendous API}
\usage{
trem_delete(
  client,
  path,
  query = list(),
  body = NULL,
  disk = NULL,
  stream = NULL,
  encode = "json",
  parse = TRUE
)
}
\arguments{
\item{client}{A Tremendous API Client object, created with
\code{\link{trem_client_new}}.}

\item{path}{The URL path, appended to the base URL, for GET requests such as
listing available payment types, funding sources, account members, and
more. See the \href{https://developers.tremendous.com/}{Tremendous API Documentation} for examples.}

\item{query}{Query terms as a named list. See \link[crul:HttpClient]{crul::HttpClient} for more
details.}

\item{body}{Request body for Tremendous API, as an R List.}

\item{disk}{A path to write to. \code{NULL} by default, so info is written to
memory. See \link[crul:HttpClient]{crul::HttpClient} for more details.}

\item{stream}{An R function to determine how to stream data. \code{NULL} by
default, so info is streaned with memory. See \link[crul:HttpClient]{crul::HttpClient} for more
details.}

\item{encode}{"json" by default based on Tremendous API Request format. See
\link[crul:HttpClient]{crul::HttpClient} for more options.}

\item{parse}{Logical: Should the API Response results be parsed into a data
frame?}
}
\value{
If \code{parse = TRUE} (default), a list containing the response from the
API request. Otherwise, the R6 HttpResponse object containing API request
data.
}
\description{
Tremendous only supports DELETE requests for one endpoint -- deleting an
invoice. Per \href{https://developers.tremendous.com/reference/core-invoices-delete}{their documentation},
this request "removes an invoice. This has no further consequences but is a
rather cosmetic operation." See the examples for a walk-through.
}
\examples{

\dontrun{

  # Create a new Tremendous API Client
  test_client <- trem_client_new(api_key = "TEST_YOUR-API-KEY-HERE",
                                 sandbox = TRUE)

  # Perform a POST request for an invoice.
  # `po_number` is Reference to the purchase order number within your organization
  # `amount` is in USD
  trem_post(test_client,
            path = "invoices",
            body = list(po_number = "unique-invoice-id",
                        amount = 50)
  )

  # Perform a GET request for listing all current (non-deleted) invoices.
  current_invoices <- trem_get(test_client, "invoices")

  # Get index for the correct ID
  unique_id_index <- which(current_invoices$invoices$po_number == "unique-invoice-id")

  # Get the invoice ID for 'unique-invoice-id' to delete
  my_invoice_id <- current_invoices$invoices[unique_id_index, "id"]

  # Perform a DELETE request for the specific invoice.
  trem_delete(test_client, paste0("invoices/", my_invoice_id))

  # Perform a GET request for listing all current (non-deleted) invoices.
  # The one with id po_number 'unique-invoice-id' should no longer be here.
  trem_get(test_client, "invoices")

}


}
