% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-list.R
\name{fit.list}
\alias{fit.list}
\title{Fit method list object}
\usage{
\method{fit}{list}(x, data, ...)
}
\arguments{
\item{x}{A list of trending_model objects}

\item{data}{A data frame containing the data to fit.}

\item{...}{Not currently used.}
}
\value{
A \code{trending_fit_tbl} object which is a \code{\link[tibble:tibble]{tibble}}
subclass with one row for each model and entries:
\itemize{
\item model_name (optional): If the input is a named list then the name is
extracted.
\item result: the resulting fit from calling the underlying model
directly, i.e.
\itemize{
\item \code{lm_model}: a fitted model object of class \code{\link[stats:lm]{lm}}
\item \code{glm_model}: a fitted model object of class \code{\link[stats:glm]{glm}}
\item \code{glm_nb_model}: a fitted model object of class \code{\link[MASS:glm.nb]{negbin}}
\item \code{brm_model}: An object of class \code{\link[brms:brm]{brmsfit}}
}

\code{NULL} if fitting fails.
\item warnings: any warnings generated during fitting
\item errors: any errors generated during fitting
}
}
\description{
Fits a list of trending_model objects to the given input data.
}
\examples{
x = rnorm(100, mean = 0)
y = rpois(n = 100, lambda = exp(1.5 + 0.5*x))
dat <- data.frame(x = x, y = y)
poisson_model <- glm_model(y ~ x , family = poisson)
negbin_model <- glm_nb_model(y ~ x)

fit(list(poisson_model, negbin_model), dat)
fit(list(pm = poisson_model, nm = negbin_model), dat)

}
\seealso{
\code{\link[=fit.trending_model]{fit.trending_model()}}
}
\author{
Tim Taylor
}
