% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triversity.R
\name{get_conditional_diversity_from_transition}
\alias{get_conditional_diversity_from_transition}
\title{Compute the conditional diversity of a transition matrix.}
\usage{
get_conditional_diversity_from_transition(transition, distribution = NULL,
  order = NULL, measure = NULL)
}
\arguments{
\item{transition}{A matrix of floats in [\code{0},\code{1}], with all lines summing to \code{1},
giving the transition matrix from which the conditional diversity values are computed.}

\item{distribution}{A vector of floats in [\code{0},\code{1}] and summing to \code{1} giving
the probability
distribution that is used to weight the diversity values when computing their geometric means.
It should hence contain as many values as there are rows in the input \code{transition}. If not
specified, this distribution is assumed uniform.}

\item{order}{A vector of positive floats (possibly including \code{Inf}) giving the
orders of the diversity measures to be computed. If neither \code{order} nor \code{measure} is
specified, a predefined list of 8 diversity measures is computed.}

\item{measure}{A vector of strings giving the names of the diversity measures to compute.
Possible values are \code{richness}, \code{entropy}, \code{herfindahl},
and \code{bergerparker}.}
}
\value{
A vector of positive floats giving the conditional diversity values of the input
\code{transition} matrix, that is the geometric means of the diversity values associated
to its rows.
}
\description{
\code{get_conditional_diversity_from_transition} computes the geometric means of diversity
values associated to the lines of the input \code{transition} matrix, while weighting these values
according to an optional input \code{distribution}. This hence allows to compute conditional
diversity values associated to the matrix.
}
\examples{
transition <- matrix (c (1/3, 1/3, 1/3, 0.9, 0.1, 0), nrow=2, ncol=3, byrow=TRUE)
get_conditional_diversity_from_transition (transition, order=c(0,Inf), measure='entropy')
get_conditional_diversity_from_transition (transition, distribution=c(0.75,0.25))

}
