% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_source_priors_params_arc.R
\name{two_source_priors_params_arc}
\alias{two_source_priors_params_arc}
\title{Adjust Bayesian priors - Two Source Trophic Position with \eqn{\alpha_r} and carbon mixing model}
\usage{
two_source_priors_params_arc(
  a = NULL,
  b = NULL,
  n1 = NULL,
  n1_sigma = NULL,
  n2 = NULL,
  n2_sigma = NULL,
  c1 = NULL,
  c1_sigma = NULL,
  c2 = NULL,
  c2_sigma = NULL,
  dn = NULL,
  dn_sigma = NULL,
  tp_lb = NULL,
  tp_ub = NULL,
  sigma_lb = NULL,
  sigma_ub = NULL,
  bp = FALSE
)
}
\arguments{
\item{a}{(\eqn{\alpha}) exponent of the random variable for beta distribution.
Defaults to \code{1}. See beta distribution for more information.}

\item{b}{(\eqn{\beta}) shape parameter for beta distribution.
Defaults to \code{1}. See beta distribution for more information.}

\item{n1}{mean (\eqn{\mu}) prior for first \eqn{\delta^{15}}N
baseline. Defaults to \code{8.0}.}

\item{n1_sigma}{variance (\eqn{\sigma})for first
\eqn{\delta^{15}}N baseline. Defaults to \code{1}.}

\item{n2}{mean (\eqn{\mu}) prior for second \eqn{\delta^{15}}N
baseline. Defaults to \code{9.5}.}

\item{n2_sigma}{variance (\eqn{\sigma}) for second
\eqn{\delta^{15}}N  baseline. Defaults to \code{1}.}

\item{c1}{mean (\eqn{\mu}) prior for first \eqn{\delta^{13}}C
baseline. Defaults to \code{-21}.}

\item{c1_sigma}{variance (\eqn{\sigma})for first
\eqn{\delta^{13}}C baseline. Defaults to \code{1}.}

\item{c2}{mean (\eqn{\mu}) prior for second \eqn{\delta^{13}}C
baseline. Defaults to \code{-26}.}

\item{c2_sigma}{variance (\eqn{\sigma}) for second
\eqn{\delta^{13}}C  baseline. Defaults to \code{1}.}

\item{dn}{mean (\eqn{\mu}) prior value for \eqn{\Delta}N. Defaults to \code{3.4}.}

\item{dn_sigma}{variance (\eqn{\sigma}) for \eqn{\delta^{15}}N.
Defaults to \code{0.25}.}

\item{tp_lb}{lower bound for priors for trophic position. Defaults to \code{2}.}

\item{tp_ub}{upper bound for priors for  trophic position. Defaults to \code{10}.}

\item{sigma_lb}{lower bound for priors for \eqn{\sigma}. Defaults to \code{0}.}

\item{sigma_ub}{upper bound for priors for \eqn{\sigma}. Defaults to \code{10}.}

\item{bp}{logical value that controls whether informed baseline priors are
supplied to the model for \eqn{\delta^{15}}N baselines. Default is
\code{FALSE} meaning the model will use uninformed priors, however, the supplied
\code{data.frame} needs values for both \eqn{\delta^{15}}N baseline
(\code{n1} and \code{n2})}
}
\value{
\code{stanvars} object to be used with \code{brms()} call.
}
\description{
Adjust priors for trophic position using a two source model
with \eqn{\alpha_r} derived from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}
and Heuvel et al. (2024) \doi{doi:10.1139/cjfas-2024-0028}
}
\details{
We will use the following equations derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002} and Heuvel et al. (2024) \doi{doi:10.1139/cjfas-2024-0028}:

\enumerate{
\item \deqn{\alpha = (\delta^{13} C_c - \delta ^{13}C_2) /
  (\delta ^{13}C_1 - \delta ^{13}C_2)}

\item \deqn{\alpha = \alpha_r \times (\alpha_{max} - \alpha_{min}) + \alpha_{min}}

\item \deqn{\delta^{13}C = c_1 \times \alpha_r + c_2 \times (1 - \alpha_r)}

\item \deqn{\delta^{15}N = \Delta N \times (tp - \lambda_1) + n_1 \times \alpha_r + n_2 \times (1 - \alpha_r)}

\item \deqn{\delta^{15}N = \Delta N \times (tp - (\lambda_1 \times \alpha_r + \lambda_2 \times (1 - \alpha_r))) + n_1 \times \alpha_r + n_2 \times (1 - \alpha_r)}
}

\strong{For equation 1)}

This equation is a carbon source mixing model with
\eqn{\delta^{13}C_c} is the isotopic value for consumer,
\eqn{\delta^{13}C_1} is the mean isotopic value for baseline 1 and
\eqn{\delta^{13}C_2} is the mean isotopic value for baseline 2.

\strong{For equation 2)}

\eqn{\alpha} is being corrected using equations in
Heuvel et al. (2024) \doi{doi:10.1139/cjfas-2024-0028}.
with \eqn{\alpha_r} being the corrected value (bound by 0 and 1),
\eqn{\alpha_{min}} is the minimum \eqn{\alpha} value calculated
using \code{add_alpha()} and \eqn{\alpha_{max}} being the maximum \eqn{\alpha}
value calculated using \code{add_alpha()}.

\strong{For equation 3)}

This equation is a carbon source mixing model with \eqn{\delta^{13}}C being
estimated using \code{c_1}, \code{c_2}  and \eqn{\alpha_r} calculated in equation 1.

\strong{For equation 4) and 5)}

\eqn{\delta^{15}}N are values from the consumer,
\eqn{n_1} is \eqn{\delta^{15}}N values of baseline 1, \eqn{n_2} is
\eqn{\delta^{15}}N values of baseline 2,
\eqn{\Delta}N is the trophic discrimination factor for N (i.e., mean of \code{3.4}),
tp is trophic position, and  \eqn{\lambda_1} and/or
\eqn{\lambda_2} are the trophic levels of
baselines which are often a primary consumer (e.g., \code{2} or \code{2.5}).

This function allows the user to adjust the priors for the following variables
in the equation above:

\itemize{
\item The random exponent (\eqn{\alpha}; \code{a})
and shape parameters (\eqn{\beta}; \code{b}) for \eqn{\alpha_r}. This prior
assumes a beta distribution.
\item The mean (\code{n2};\eqn{\mu}) and variance (\code{n2_sigma}; \eqn{\sigma}) of
the second \eqn{\delta^{15}}N for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{c1};\eqn{\mu}) and variance (\code{c1_sigma}; \eqn{\sigma}) of
the second \eqn{\delta^{13}}C for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{c2};\eqn{\mu}) and variance (\code{c2_sigma}; \eqn{\sigma}) of
the second \eqn{\delta^{13}}C for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{dn}; \eqn{\mu}) and variance (\code{dn_sigma}; \eqn{\sigma}) of
\eqn{\Delta}N (i.e, trophic enrichment factor).
This prior assumes a normal distributions.
\item The lower (\code{tp_lb}) and upper (\code{tp_ub}) bounds for priors for
trophic position. This prior assumes a uniform distributions.
\item The lower (\code{sigma_lb}) and upper (\code{sigma_ub}) bounds for
variance (\eqn{\sigma}). This prior assumes a uniform distributions.
}
}
\examples{
two_source_priors_params_ar()
}
\seealso{
\code{\link[=two_source_priors_arc]{two_source_priors_arc()}}, \code{\link[=two_source_model_arc]{two_source_model_arc()}}, and \code{\link[brms:brms-package]{brms::brms()}}
}
