% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal.R
\name{fourier_series}
\alias{fourier_series}
\title{Fourier terms for modeling seasonality}
\usage{
fourier_series(dates, period = NULL, K = NULL)
}
\arguments{
\item{dates}{a Date vector representing the length of the series for which
the fourier terms are required.}

\item{period}{frequency of the underlying series, if NULL will try to
infer it from the difference in the Date vector.}

\item{K}{maximum order of the Fourier terms.}
}
\value{
A matrix of size N (length of dates) by 2*K.
}
\description{
Returns a matrix containing terms from a Fourier series, up to order K
}
