% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula2.R
\docType{class}
\name{dvinecopula2-class}
\alias{dvinecopula2-class}
\alias{coef,dvinecopula2-method}
\alias{show,dvinecopula2-method}
\alias{sim,dvinecopula2-method}
\alias{predict,dvinecopula2-method}
\alias{kendall,dvinecopula2-method}
\title{D-vine copula processes of type 2}
\usage{
\S4method{coef}{dvinecopula2}(object)

\S4method{show}{dvinecopula2}(object)

\S4method{sim}{dvinecopula2}(object, n = 1000)

\S4method{predict}{dvinecopula2}(object, data, x, type = "df")

\S4method{kendall}{dvinecopula2}(object, lagmax = 20)
}
\arguments{
\item{object}{an object of the class.}

\item{n}{length of realization.}

\item{data}{vector of past data values.}

\item{x}{vector of arguments of prediction function.}

\item{type}{type of prediction function ("df" for density, "qf" for quantile function
or "dens" for density).}

\item{lagmax}{maximum value of lag.}
}
\description{
Class of objects for d-vine copula processes. See \link{dvinecopula2} for more details.
}
\section{Methods (by generic)}{
\itemize{
\item \code{coef(dvinecopula2)}: Coef Method for dvinecopula2 class

\item \code{show(dvinecopula2)}: Show method for dvinecopula2 class

\item \code{sim(dvinecopula2)}: Simulation method for dvinecopula2 class

\item \code{predict(dvinecopula2)}: Prediction method for dvinecopula2 class

\item \code{kendall(dvinecopula2)}: Calculate Kendall's tau values for pair copulas in type 2 d-vine copula

}}
\section{Slots}{

\describe{
\item{\code{name}}{name of the d-vine copula process.}

\item{\code{modelspec}}{list containing the family, rotation, and name of KPACF}

\item{\code{pars}}{list comprising of the parameters.}
}}

\examples{
copmod <- dvinecopula2(family = "joe", kpacf = "kpacf_arma",
pars = list(ar = 0.95, ma = -0.85), maxlag = 30)
kendall(copmod)
}
