% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gy_components}
\alias{plot_gy_components}
\title{Plots the growth rates and slope of the log cumulative growth rate}
\usage{
plot_gy_components(res, plt.start.date = NULL, smoothed = FALSE, title = NULL)
}
\arguments{
\item{res}{Results object estimated using the \code{estimate()} method.}

\item{plt.start.date}{Plot start date. Default is \code{NULL} which is the
start of the estimation sample.}

\item{smoothed}{Logical value indicating whether to used the smoothed
estimates of \eqn{\delta} and \eqn{\gamma}. Default is \code{FALSE}, in
which case the filtered estimates are returned.}

\item{title}{Title for plot. Enter as text string. \code{NULL} (i.e. no
title) by default.}
}
\value{
A \code{ggplot2} plot.
}
\description{
Plots the smoothed/filtered growth rate of the difference in
the cumulated variable (\eqn{g_y}), the smoothed/filtered growth rate of the
the cumulated variable (\eqn{g}), and the smoothed/filtered slope of
\eqn{\ln(g)}, \eqn{\gamma}.
Following Harvey and Kattuman (2021), we compute \eqn{g_{y,t}} as
\deqn{g_{y,t} = \exp(\delta_t) + \gamma_t.}
}
\examples{
library(tsgc)
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-20")

# Specify a model
model <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)
# Estimate a specified model
res <- model$estimate()

# Plot filtered gy, g and gamma
plot_gy_components(res, plt.start.date = as.Date("2020-07-06"))

}
