% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble-meta.R
\name{key}
\alias{key}
\alias{key_vars}
\title{or other tidyselect-compatible functions, \code{key_vars()} acts as a selection
helper that automatically selects all key columns from the tsibble.}
\usage{
key(x)

key_vars(x)
}
\arguments{
\item{x}{A tsibble.}
}
\description{
or other tidyselect-compatible functions, \code{key_vars()} acts as a selection
helper that automatically selects all key columns from the tsibble.
}
\examples{
key(pedestrian)
key_vars(pedestrian)

key(tourism)
key_vars(tourism)

# Use as a tidyselect helper
library(dplyr)
tourism \%>\% select(index_var(), key_vars())

# Combine with other tidyselect functions
tourism \%>\% relocate(key_vars(), .after = last_col())
}
