% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tscov.cgarch.estimate}
\alias{tscov.cgarch.estimate}
\alias{tscov}
\alias{tscov.cgarch.simulate}
\alias{tscov.cgarch.predict}
\alias{tscov.dcc.estimate}
\alias{tscov.dcc.simulate}
\alias{tscov.dcc.predict}
\alias{tscov.gogarch.estimate}
\alias{tscov.gogarch.predict}
\alias{tscov.gogarch.simulate}
\title{Covariance Extractor}
\usage{
\method{tscov}{cgarch.estimate}(object, distribution = TRUE, ...)

\method{tscov}{cgarch.simulate}(object, distribution = TRUE, ...)

\method{tscov}{cgarch.predict}(object, distribution = TRUE, ...)

\method{tscov}{dcc.estimate}(object, distribution = TRUE, ...)

\method{tscov}{dcc.simulate}(object, distribution = TRUE, ...)

\method{tscov}{dcc.predict}(object, distribution = TRUE, ...)

\method{tscov}{gogarch.estimate}(object, distribution = TRUE, ...)

\method{tscov}{gogarch.predict}(object, distribution = TRUE, ...)

\method{tscov}{gogarch.simulate}(object, distribution = TRUE, ...)
}
\arguments{
\item{object}{an object class from one of the models in the package.}

\item{distribution}{whether to return the full simulated covariance distribution
for the predicted and simulated objects, else the average covariance across each
horizon.}

\item{...}{none}
}
\value{
the covariance (see details).
}
\description{
Extracts the conditional covariance matrices.
}
\details{
\subsection{Estimation Object}{

An array of covariance matrices with time as the third dimension.
The returned object has attributes \sQuote{index} representing the datetime
and \sQuote{series} representing the series names.
}

\subsection{Simulation and Prediction Objects}{

A 4-d array of dimensions (n_series x n_series x horizon x n_draws). If
\code{distribution} is FALSE, then the average covariance across all draws, an
array of dimensions (n_series x n_series x horizon).
}
}
\author{
Alexios Galanos
}
