% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvParameter.R
\name{tvParameter}
\alias{tvParameter}
\title{Structure of the Time-Varying GARCH(1,1) Parameters}
\usage{
tvParameter(data, S, N, plot = TRUE)
}
\arguments{
\item{data}{Represents the financial return series employed to investigate the temporal evolution of the parameters in the tv-GARCH(1,1) model.}

\item{S}{The number of observations by which the analysis window is shifted to define the starting point of the next block; also known as the step size or shift parameter.}

\item{N}{The total number of observations contained within each data block, representing the block or window length over which local model estimation is performed.}

\item{plot}{A Boolean flag indicating whether a graphical representation of the estimation results should be generated.}
}
\value{
Data frame who contains omega, alpha, beta of GARCH(1,1) model and midpoint each block.
}
\description{
This function performs an exploratory analysis to uncover the dynamic structure of the time-varying GARCH(1,1) parameters. Specifically, the observation domain \eqn{\{1, \ldots,T\}} is partitioned into \eqn{M} overlapping blocks, each of length \eqn{N}, with a constant shift of size \eqn{S} between consecutive blocks. The relation between these quantities satisfies \eqn{T = S(M-1)+N}. The midpoint of the \eqn{j}-th block, for \eqn{j=1,\ldots,M}, is denoted \eqn{t_j=S(j-1)+N/2}. For each block, a local estimation of the stationary GARCH(1,1) model is performed using the observations within that block. The resulting sequence of local estimates, evaluated across all blocks, provides an empirical trajectory that reflects the underlying evolution of the time-varying parameters. This trajectory can serve as a guide for selecting flexible function classes capable of capturing their temporal variation.
}
\examples{
ipsa<-diff(log(indipsa))*100
S = 100
N = 800
tv <- tvParameter(ipsa,S,N)
}
