% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvYearAnnuityCompMonthly.R
\name{pvYearlyAnnuityCompMonthly}
\alias{pvYearlyAnnuityCompMonthly}
\title{Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.}
\usage{
pvYearlyAnnuityCompMonthly(r, n, pmt, bgn)
}
\arguments{
\item{r}{A number.}

\item{n}{A number.}

\item{pmt}{A number.}

\item{bgn}{A number.}
}
\value{
Input values to four arguments \code{r} , \code{n} , \code{pmt} and \code{bgn}
}
\description{
Computing Present Value of Yearly Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.
}
\details{
As explained by \insertCite{humm;textual}{tvmComp}, the description of the Compounding Frequency is usually contained within the phrase that describes the nominal interest rate. An example would be 24 percent compounded monthly. This means that the nominal, or annual, interest rate of 24 percent is compounded 12 times each year at 24/12 that is 2 percent, each period.
The method \code{pvYearlyAnnuityCompMonthly()} is developed to compute Present Value of Yearly-Paid Ordinary Annuity or Annuity Due that is Compounded Monthly.The method gives Present Value when values are passed to its four arguments. Here \code{r} is annual rate,\code{n} is number of years,\code{pmt} is amount of one annuity and \code{bgn} is the computational mode. (Enter 1 when annuity payment occurs at the beginning of the period; 0 for end of period payments).
}
\examples{
pvYearlyAnnuityCompMonthly(0.11,4,-300,0)
pvYearlyAnnuityCompMonthly(0.11,4,-300,1)
pvYearlyAnnuityCompMonthly(0.11,4,300,0)
pvYearlyAnnuityCompMonthly(0.11,4,300,1)
}
\references{
\insertRef{humm}{tvmComp}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
