% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CurveFuncs.R
\name{rate_curve}
\alias{rate_curve}
\title{Creates a rate curve instance}
\usage{
rate_curve(
  rates = NULL,
  rate_type = "zero_eff",
  pers = 1:length(rates),
  rate_scale = 1,
  fun_d = NULL,
  fun_r = NULL,
  knots = seq.int(from = 1, to = max(pers), by = 1),
  functor = function(x, y) splinefun(x = x, y = y, method = "monoH.FC")
)
}
\arguments{
\item{rates}{A rate vector}

\item{rate_type}{The rate type. Must be on of c("fut", "zero_nom", "zero_eff", "swap", "zero_cont)}

\item{pers}{The periods the rates correspond to}

\item{rate_scale}{In how many periods is the rate expressed.
For example, when measuring periods in days, and using annual rates, you should use 365. 
When measuring periods in months, and using annual rates, you should use 12.
If no scaling, use 1.}

\item{fun_d}{A discount factor function. fun_d(x) returns the discount factor for time x, vectorized on x}

\item{fun_r}{A rate function. fun_r(x) returns the EPR for time x, vectorized on x}

\item{knots}{The nodes used to bootstrap the rates. This is a mandatory argument if a rate function or discount function is provided}

\item{functor}{A function with parameters x and y, that returns a function used to interpolate}
}
\description{
Creates a rate curve instance
}
\note{
Currently a rate curve can only be built from one of the following sources
\enumerate{
\item A discount factor function
\item A rate function and a rate type from the following types: "fut", "zero_nom", "zero_eff", "swap" or "zero_cont
\item A rate vector, a pers vector and a rate type as before
}
}
\examples{
rate_curve(rates = c(0.1, 0.2, 0.3), rate_type = "zero_eff")
rate_curve(fun_r = function(x) rep_len(0.1, length(x)), rate_type = "swap", knots = 1:12)
rate_curve(fun_d = function(x) 1 / (1 + x), knots = 1:12)
}
