% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{era.splits}
\alias{era.splits}
\title{era.splits}
\usage{
era.splits(dat, cut.points, id.name = "id", t1.name = "t1", t2.name = "t2")
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{cut.points}{A numeric vector specifying the endpoints of each era. Each value defines
the end of one era and the beginning of the next, allowing records to be split into intervals
such as [min(x), 10), [10, 20), and [20, max(x)). A row with t1 = 0 and t2 = 30, and cut points
at 10 and 20, would be divided into intervals of [0,10), [10,20), and [20,30).}

\item{id.name}{The character name of the identifying variable within dat, used for
tracking subjects across multiple rows.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}
}
\value{
Returns a data table that has been restructured to reflect the specified era splits.
Original rows overlapping multiple eras are divided into multiple rows, each representing a
discrete interval within the specified eras. The function ensures each subject's observation
period is accurately represented according to the specified time intervals. The output is
sorted by the identifying variable and the start time of each interval, facilitating further
analysis or processing that depends on temporal segmentation.
}
\description{
Restructures panel data by dividing records into distinct eras based on specified
cut points. Rows that span multiple eras are split into separate rows for each era they
encompass. For example, a record spanning from 0 to 2 years could be split into two records:
one for the first year (0-1) and another for the second year (1-2), if the cut points are
set at each year mark. This process is useful for analyzing data within specific time intervals.
}
