#' Opzoeken van de TWN informatie
#'
#' De `twn_*` - functies zoeken informatie uit de TWN-lijst op.
#'
#' @details Deze functies accepteren een vector met taxonnamen en retourneren de
#'   betreffende informatie uit de TWN-lijst. Als de taxonnaam niet in de
#'   TWN-lijst voorkomt retourneert de functie `NA`.
#'
#'   - `twn_voorkeurnaam()`: Geeft de voorkeurnaam van het taxon. Als het al de
#'   voorkeurnaam is wordt de originele naam teruggegeven.
#'   - `twn_refername()`: Alias voor `twn_voorkeurnaam()`.
#'   - `twn_parent()`: Geeft de parent van het taxon. 
#'   - `twn_ouder()`: Alias voor `twn_parent()`.
#'   - `twn_status()`: Geeft de status(code) van het taxon. 
#'   - `twn_localname()`: Geeft de Nederlandse naam van het taxon. 
#'   - `twn_nednaam()`: Alias voor `twn_localname()`.
#'   - `twn_taxonlevel()`: Geeft het taxonomische niveau van het taxon.
#'   - `twn_taxonniveau()`: Alias voor `twn_taxonlevel()`
#'   - `twn_taxontype()`: Geeft het taxontype van het taxon. 
#'   - `twn_datum()`: Geeft de datum meest recente wijziging van het taxon.
#'   - `twn_date()`: Alias voor `twn_datum()`.
#'
#' @param taxa Een vector met taxonnamen.
#' @param code Logisch. Geeft aan of de code of de omschrijving wordt geretourneerd.
#'
#' @return Een vector met TWN-informatie. Taxonnamen die niet in de TWN worden
#'   gevonden krijgen `NA`.
#'   
#' @note De TWN-lijst is niet altijd volledig consistent. Diverse taxa staan
#'   meerdere malen in de lijst. In dat geval wordt het eerste resultaat met 
#'   de laagste statuscode geretourneerd.
#'   
#'   NB sommige taxa hebben meer dan 1 taxontype. In dat geval zijn de 
#'   taxontypen gecombineerd in een string in alfabetische volgorde 
#'   gescheiden door een spaties.
#'   
#'   Als een taxon niet de voorkeurnaam is dan ontbreekt er vaak informatie 
#'   zoals de parent van het taxon. De functie `twn_parent` zoekt in dat
#'   geval de parent van de voorkeurnaam.
#'
#' @examples
#' taxa <- c("Bufo calamita", "Bufo")
#' 
#' twn_voorkeurnaam(taxa)
#' twn_parent(taxa)
#' twn_status(taxa)
#' twn_localname(taxa)
#' twn_taxonlevel(taxa)
#' twn_taxontype(taxa)
#' twn_datum(taxa)
#'
#' @name twn_info
#' @seealso Deze functies werken op basis van de tabel [twn_lijst]
#'   
NULL


#' @rdname twn_info
#' @export
twn_voorkeurnaam <- function(taxa){
  unname(opzoektabel_twn_voorkeur[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_refername <- twn_voorkeurnaam 

#' @rdname twn_info
#' @export
twn_parent <- function(taxa){
  unname(opzoektabel_twn_parent[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_ouder <- twn_parent

#' @rdname twn_info
#' @export
twn_status <- function(taxa, code = TRUE){
  if (code) unname(opzoektabel_twn_status[as.character(taxa)])
  else unname(opzoektabel_twn_status_tekst[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_localname <- function(taxa){
  unname(opzoektabel_twn_localname[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_nednaam <- twn_localname 

#' @rdname twn_info
#' @export
twn_taxonlevel <- function(taxa){
  unname(opzoektabel_twn_taxonlevel[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_taxonniveau <- twn_taxonlevel

#' @rdname twn_info
#' @export
twn_taxontype <- function(taxa){
  unname(opzoektabel_twn_taxontype[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_datum <- function(taxa){
  unname(opzoektabel_twn_datum[as.character(taxa)])
}

#' @rdname twn_info
#' @export
twn_date <- twn_datum
